import { Component, OnInit } from '@angular/core';
import { Router } from "@angular/router";
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-recruiting',
  templateUrl: './recruiting.component.html',
  styleUrls: ['./recruiting.component.scss']
})
export class RecruitingComponent implements OnInit {
  recruitingList: Array<any>;
  titleList: Array<any>;
  selectedId: any;
  constructor(private router: Router, private myService: MyService) { }

  ngOnInit() {
    this.titleList = [
      { id: 1, name: '待跟进' },
      { id: 2, name: '跟进中' },
      { id: 3, name: '已报聘' },
    ]
    this.selectTab(1)
  }

  addMember() {
    this.router.navigate(['/recruiting/0']);
  }
  selectTab(id) {
    this.selectedId = id;
    this.recruitListQuery(id)
  }

  //1-待跟进，2-跟进中，3-已完成
  recruitListQuery(type) {
    const listParam = {
      status: type,
      practitionerId: JSON.parse(localStorage.getItem('lifeCustomerInfo')).practitionerId
    }
    this.myService.recruitListQuery(listParam).subscribe((res) => {
      if (res['success']) {
        this.recruitingList = res['data']['practitionerPotentialInfoList']
      }
    })
  }
}
