import { Component, OnInit } from '@angular/core';
import { MyService } from '../my.service';
import { ActivatedRoute, Router } from "@angular/router";

@Component({
  selector: 'ydlife-score-details',
  templateUrl: './score-details.component.html',
  styleUrls: ['./score-details.component.scss']
})
export class ScoreDetailsComponent implements OnInit {
  salesScoreDetails: Array<any>;
  selectedTime: string;
  practitionerId:number;
  constructor(private activateRoute: ActivatedRoute,private myService: MyService) { }
  ngOnInit() {
    this.selectedTime = 'D';
    this.salesScoreDetailQuery('D');
    if(this.activateRoute.snapshot.paramMap.get('practitionerId')){
      this.practitionerId = Number(this.activateRoute.snapshot.paramMap.get('practitionerId'));
    }else{
      this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    }
  }

  //销售活动量详情D-天 W-周 M-月
  salesScoreDetailQuery(time) {
    this.selectedTime = time;
    const practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.myService.salesScoreDetailQuery({ practitionerId: practitionerId, time: this.selectedTime }).subscribe((res) => {
      if (res['success']) {
        this.salesScoreDetails = res['data']['salesScoreDetails'];
      }
    })
  }

}
