import { Component, OnInit } from '@angular/core';
import { LifeCommonService } from '../../common/life-common.service';
import {MyService} from '../my.service';
import * as dayjs from 'dayjs';

@Component({
  selector: 'ydlife-todo-list',
  templateUrl: './todo-list.component.html',
  styleUrls: ['./todo-list.component.scss']
})
export class TodoListComponent implements OnInit {
  weekArr: Array<any>;
  taskList:Array<any> = [];
  taskTimeList:Array<any> = [];
  trackTime:string;
  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: 'one',
    enterDirection: '',
    rowSize: 'normal',
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+new Date() - 5184000000),
    maxDate: new Date(+new Date() + 31536000000),
    onSelect: undefined,
  }
  practitionerId:number;
  constructor(public lifeCommonService: LifeCommonService,private myService:MyService) {
    this.taskTimeList = [
      {id:1,time:'8:00'},
      {id:2,time:'9:00'},
      {id:3,time:'10:00'},
      {id:4,time:'11:00'},
      {id:5,time:'12:00'},
      {id:6,time:'13:00'},
      {id:7,time:'14:00'},
      {id:8,time:'15:00'},
      {id:9,time:'16:00'},
      {id:10,time:'17:00'},
      {id:11,time:'18:00'},
      {id:12,time:'19:00'},
    ]
   }
  
  ngOnInit() {
    //进页面清除上次缓存的时间
    sessionStorage.removeItem("trackTime");
    this.practitionerId = JSON.parse(localStorage.getItem('lifeCustomerInfo'))['practitionerId'];
    this.weekArr = this.lifeCommonService.makeDate();
    //初始化追踪时间为今天
    this.trackTime = dayjs().format('YYYY-MM-DD');
    this.queryScheduleTrackList();
  }

  goBack(){
    history.go(-1)
  }

  selectDay(weekItem){
    this.trackTime =  weekItem['date'];
    //缓存任务时间
    sessionStorage.setItem('trackTime',this.trackTime);
    this.queryScheduleTrackList();
  }

  initPara() {
    this.state = {
      ...this.state,
      ...{
        show: false,
        date: null,
        pickTime: false,
        now: new Date(),
        type: 'one',
        rowSize: 'normal',
        infinite: true,
        enterDirection: '',
        onSelect: undefined,
        showShortcut: false,
        defaultValue: undefined,
      }
    };
  }

  clickCalendar(){
    this.initPara();
    this.state.show = true;
    this.state.date = new Date(); 
  }

  triggerCancel() {
    this.state.show = false;
  }

  triggerConfirm(value) {
    const { startDate, endDate } = value;
    this.state = {
      ...this.state,
      show: false,
      startDate, 
      endDate
    };
    this.triggerCancel();
    this.trackTime =dayjs(startDate).format('YYYY-MM-DD');
    //缓存任务时间
    sessionStorage.setItem('trackTime',this.trackTime);
    this.queryScheduleTrackList();
    this.weekArr = this.lifeCommonService.makeDate(startDate);
  }

  queryScheduleTrackList(){
    this.myService.queryScheduleTrackList({practitionerId:this.practitionerId,trackTime:this.trackTime}).subscribe((res)=>{
      if(res['success']){
        this.taskList = res['data']['dataList'];
      }else{
        this.taskList = [];  
      }
    })
  }
}
