import { Component, OnInit } from '@angular/core';
import {MyService} from '../my.service';
import { ModalService, ToastService } from 'ng-zorro-antd-mobile';
import { Router } from "@angular/router";
import {LifeCommonService} from '../../common/life-common.service';

@Component({
  selector: 'ydlife-add-task',
  templateUrl: './add-task.component.html',
  styleUrls: ['./add-task.component.scss'],
})
export class AddTaskComponent implements OnInit {
  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: 'one',
    enterDirection: '',
    rowSize: 'normal',
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+new Date() - 5184000000),
    maxDate: new Date(+new Date() + 31536000000),
    onSelect: undefined,
  }
  tabList:Array<any>;
  tabType:string;
  salesActivityList:Array<any>;
  taskImportantTag:boolean = false;
  seasons:Array<any>;
  taskTimeFrom:Array<any>=[];
  taskTimeEnd:Array<any> = [];
  longTermList:Array<any>;
  taskType:number;
  mdDropOptionId:any;
  notice:string;
  linkToastFlag:boolean = false;
  totastTitle:string;
  trackTime:any;
  constructor(private myService:MyService,private router: Router,private _modal: ModalService, private _toast: ToastService,
   public lifeCommonService:LifeCommonService) {
    this.seasons = [
      {label: '8:00',id:1},
      {label: '8:30',id:2},
      {label: '9:00',id:3},
      {label: '9:30', id:4},
      {label: '10:00',id:5},
      {label: '10:30',id:6},
      {label: '11:00',id:7},
      {label: '11:30',id:8},
      {label: '12:00',id:9},
      {label: '12:30',id:10},
      {label: '13:00',id:11},
      {label: '13:30',id:12},
      {label: '14:00',id:13},
      {label: '14:30',id:14},
      {label: '15:00',id:15},
      {label: '15:30',id:16},
      {label: '16:00',id:17},
      {label: '16:30',id:18},
      {label: '17:00',id:19},
      {label: '17:30',id:20},
      {label: '18:00',id:21},
      {label: '18:30',id:22},
      {label: '18:00',id:23},
      {label: '19:30',id:24},
      {label: '17:30',id:25},
      {label: '18:00',id:26},
      {label: '18:30',id:27},
      {label: '18:00',id:28},
      {label: '19:30',id:29},
    ];
    this.longTermList = [
      {name:'周一',isLongTermTask:false},
      {name:'周二',isLongTermTask:false},
      {name:'周三',isLongTermTask:false},
      {name:'周四',isLongTermTask:false},
      {name:'周五',isLongTermTask:false},
      {name:'周六',isLongTermTask:false},
      {name:'周日',isLongTermTask:false}
    ];
    // console.log(this.router.getCurrentNavigation().extras.state)
   }

   initPara() {
    this.state = {
      ...this.state,
      ...{
        show: false,
        date: null,
        pickTime: false,
        now: new Date(),
        type: 'one',
        rowSize: 'normal',
        infinite: true,
        enterDirection: '',
        onSelect: undefined,
        showShortcut: false,
        defaultValue: undefined,
      }
    };
  }

  ngOnInit() {
    this.tabList = [{code:'bizchance_promotion_action',name:'营销',taskType:1},{code:'team_building_track',name:'增员',taskType:2},{code:'pep_schedule_task_others',name:'其他',taskType:3}];
    this.tabType = 'bizchance_promotion_action';
    this.dropOptionsQuery(this.tabType);
    //如果有缓存切换到缓存数据
    if(JSON.parse(sessionStorage.getItem('pageDwellDtatus'))){
      this.tabType =  JSON.parse(sessionStorage.getItem('pageDwellDtatus'))['tabType'];
      this.dropOptionsQuery(this.tabType);
      this.mdDropOptionId = JSON.parse(sessionStorage.getItem('pageDwellDtatus'))['mdDropOptionId'];
    }else{
      this.tabType = 'bizchance_promotion_action';
      this.mdDropOptionId = null;
    }
  }

  goBack(){
    history.go(-1);
  }

  //判断是否选择同一个tab
  selectTab(code,taskType){
    let pageDwellDtatus = {};
    if(this.tabType == code){
       pageDwellDtatus = {
        tabType:this.tabType,
        mdDropOptionId:this.mdDropOptionId,
        taskType:this.taskType
      }
      sessionStorage.setItem('pageDwellDtatus',JSON.stringify(pageDwellDtatus));
    }else{
      this.tabType = code;
      this.taskType = taskType;
      this.mdDropOptionId = null;
      this.dropOptionsQuery(this.tabType);
      pageDwellDtatus = {
        tabType:this.tabType,
        mdDropOptionId:null,
        taskType:this.taskType
      }
      sessionStorage.setItem('pageDwellDtatus',JSON.stringify(pageDwellDtatus));
    } 
  }

  dropOptionsQuery(code){
    this.myService.dropOptionsQuery({code:code}).subscribe((res)=>{
      if(res['success']){
        this.salesActivityList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
      }
    })
  }

  onChange(result,type) {
    if(type===1){
      this.taskTimeFrom = result;
      console.log(this.taskTimeFrom);
    }
    if(type===2){
      console.log(this.taskTimeEnd)
      this.taskTimeEnd=result;
    }
  }

  selectTask(id){
    this.mdDropOptionId=id;
    const pageDwellDtatus = {
      tabType:this.tabType,
      mdDropOptionId:this.mdDropOptionId,
      taskType:this.taskType
    }
    sessionStorage.setItem('pageDwellDtatus',JSON.stringify(pageDwellDtatus));
    if(this.tabType == 'bizchance_promotion_action' ){
      // this.linkToastFlag = true;
      this.totastTitle = '商机';
    }
    if(this.tabType == 'team_building_track'){
      // this.linkToastFlag = true;
      this.totastTitle = '增员';
    }
    ModalService.alert(`是否联系到${this.totastTitle}`, '', [
      { text: '否', onPress: () =>  this.linkToastFlag=false,
        style: {
          borderTop:'1px #ddd solid'
        }
      },
      { text: '是', onPress: () => this.jumpToLink(),
        style: {
          color: '#f8002e',
          background: '',
          borderLeft:'1px #ddd solid',
          borderTop:'1px #ddd solid'
        }
     },
      
    ]);

  }
  getValue(result) {
    let value = [];
    let temp = '';
    result.forEach(item => {
      value.push(item.label || item);
      temp += item.label || item;
    });
    return value;
  }

  clickCalendar(){
    this.initPara();
    this.state.show = true;
    this.state.date = new Date();
  }

  triggerCancel() {
    this.state.show = false;
  }

  triggerConfirm(value) {
    const { startDate, endDate } = value;
    this.state = {
      ...this.state,
      ...{ show: false, startDate, endDate }
    };
    this.triggerCancel();
    this.trackTime = this.lifeCommonService.dateFormat(startDate,"yyyy-MM-dd")
    console.log(this.trackTime);
  }


  jumpToLink(){
    if(this.tabType == 'bizchance_promotion_action'){
      this.router.navigate(['/linkbusiness'])
    }
    if(this.tabType == 'team_building_track'){
      this.router.navigate(['/linkrecruiting'])
    }
  }

}
