import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

@Component({
  selector: 'ydlife-yd-college',
  templateUrl: './yd-college.component.html',
  styleUrls: ['./yd-college.component.scss']
})
export class YdCollegeComponent implements OnInit {
  public courseLists = [
    {no:23,name:'保险ABC',icon:'insuranceABC',link:'',path:`https://${window.location.host}/issue`,isOpen:true},
    {no:24,name:'岗前训',icon:'preJobTraining',link:'/preJobTraining',path:'',isOpen:true},
    {no:25,name:'新人训',icon:'newTraining',link:'/newTraining',path:'',isOpen:true},
    {no:26,name:'CFFP初级训',icon:'cffpElementaryTraining',link:'/cffpElementaryTraining',path:'',isOpen:true},
    {no:27,name:'提升训',icon:'promotionTraining',link:'/advanceTraining',path:'',isOpen:true},
    {no:28,name:'CFFP衔接训',icon:'cffpBridgingTraining',link:'/cffpBridgingTraining',path:'',isOpen:true},
    {no:29,name:'CFFP高阶训',icon:'cffpAdvancedTraining',link:'/cffpAdvancedTraining',path:'',isOpen:true},
    {no:30,name:'产品培训',icon:'productTraining',link:'/productTraining',path:'',isOpen:true},
    {no:31,name:'我的培训',icon:'training',link:'/myTraining',path:'',isOpen:true}
  ]
  public state = {
    modal1:false
  }

  onClose(key) {
    this.state[key] = false;
  }
  featureSelect(item){
    if(!item.isOpen){
      this.state['modal1'] = true;
    }
    if(item.path){
      window.open(item.path);
    }else if(item.link){
      this.router.navigate([`./${item.link}`]);
    }
  }
  constructor(private router:Router) { }

  ngOnInit() {
  }

}
