import { Component, OnInit } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { EmployBasicQuery } from '../../../domain/employBasicQuery';

@Component({
  selector: 'ydlife-employee-basic-info',
  templateUrl: './employee-basic-info.component.html',
  styleUrls: ['./employee-basic-info.component.scss']
})
export class EmployeeBasicInfoComponent implements OnInit {
  idTypesList:Array<any>;
  hiringBasicInfoId:any;
  editEmployBasicInfo:EmployBasicQuery = new EmployBasicQuery();
  isNeedAlert: boolean;
  dialogInfo: any;
  showPractitionerBirthdate:any = null;
  houseFlag:boolean;
  addressInfo:any;
  provinces:Array<any>;
  minDate:any = new Date('1900-01-01');
  maxDate:any = new Date();
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService) { }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    this.editEmployBasicInfo.mobileNo = this.activatedRoute.snapshot.queryParams.mobileNo?this.activatedRoute.snapshot.queryParams.mobileNo:null;
    this.erpInitialize();
    this.provCityQry();
    this.editEmployBasicInfo = new EmployBasicQuery(this.hiringBasicInfoId,null,this.editEmployBasicInfo.mobileNo,null,null,null,null,null,null,null,null,null,null,null,null)
  }

  erpInitialize(){
    this.myService.erpInitialize().subscribe((res)=>{
      if(res['success']){
        this.idTypesList = res['data']['idTypes'];
      }
    })
  }

  currentDateFormat(date, format: string = 'yyyy-mm-dd HH:MM'): any {
    if(date){
      const pad = (n: number): string => (n < 10 ? `0${n}` : n.toString());
      return format
        .replace('yyyy', date.getFullYear())
        .replace('mm', pad(date.getMonth() + 1))
        .replace('dd', pad(date.getDate()))
        .replace('HH', pad(date.getHours()))
        .replace('MM', pad(date.getMinutes()))
        .replace('ss', pad(date.getSeconds()));
    }
    
  }

  onOk(result: Date) {
    console.log(result)
    this.editEmployBasicInfo.practitionerBirthdate =  this.currentDateFormat(result, 'yyyy-mm-dd');
    this.showPractitionerBirthdate = result;
  }

  idTypeChange(e){
    this.editEmployBasicInfo.idTypeId = e;
    for(let idType  of this.idTypesList){
      if(this.editEmployBasicInfo.idTypeId == idType.id){
        this.editEmployBasicInfo.idType = idType.name;
      }
    }
  }

  /**
   * 1.证件号
   * 2.姓名
   * 3.居住地址
   * 4.email
   */
  bs(type) {
    this.lifeCommonService.scrollTo();
    if (type===1) {
      if(this.editEmployBasicInfo.idNo){
        this.editEmployBasicInfo.idNo = this.editEmployBasicInfo.idNo.trim();
        if(this.editEmployBasicInfo.idTypeId==1){
          //身份证
          this.idCardInput(this.editEmployBasicInfo.idNo);
        }else{
          if(!this.lifeCommonService.checkTaxNo(this.editEmployBasicInfo.idNo)){
            this.openPopInfo('证件号码错误');
          }
        }
      }
    }
    if(type===2){
      if(this.editEmployBasicInfo.name){
        this.editEmployBasicInfo.name = this.editEmployBasicInfo.name.trim();
      }
    }
    if(type===3){
      if(this.editEmployBasicInfo.residentAddress){
        this.editEmployBasicInfo.residentAddress = this.editEmployBasicInfo.residentAddress.trim()
      }
    }
    if(type===4){
      if(this.editEmployBasicInfo.email){
         this.editEmployBasicInfo.email = this.editEmployBasicInfo.email.trim();
      }
    }
  }


  /**
   * 身份证号码输入，获取生日和性别
   */
  idCardInput(val) {
    if (val) {
      if (!this.lifeCommonService.IdCodeValid(val).pass) {
        this.openPopInfo(this.lifeCommonService.IdCodeValid(val).msg)
        return;
      }
      this.editEmployBasicInfo.practitionerBirthdate = this.lifeCommonService.dateFormat(this.lifeCommonService.IdCodeValid(val).birthDay, 'yyyy-MM-dd');
      this.editEmployBasicInfo.gender = this.lifeCommonService.IdCodeValid(val).gender;
      this.showPractitionerBirthdate = new Date(this.editEmployBasicInfo.practitionerBirthdate);
    }
  }

  next(){
    if(!this.editEmployBasicInfo.name){
      this.openPopInfo('请输入您的姓名！')
      return;
    }else{
      if(!this.lifeCommonService.nameValid(this.editEmployBasicInfo.name)){
        this.openPopInfo('请输入您的真实姓名！')
      }
    }
    if(!this.editEmployBasicInfo.idTypeId || !this.editEmployBasicInfo.idType){
      this.openPopInfo('请选择您的证件类型！')
      return;
    }
    if(!this.editEmployBasicInfo.idNo){
      this.openPopInfo('请输入您的证件号！')
      return;
    }else{
      if(!this.lifeCommonService.checkTaxNo(this.editEmployBasicInfo.idNo)){
        this.openPopInfo('证件号码错误')
      }
    }
    if(!this.editEmployBasicInfo.practitionerBirthdate){
      this.openPopInfo('请选择您的出生日期！')
      return;
    }
    if(!this.editEmployBasicInfo.gender){
      this.openPopInfo('请选择您的性别！')
      return;
    }
    if(!this.editEmployBasicInfo.provinceId && !this.editEmployBasicInfo.cityId){
      this.openPopInfo('请选择您的户籍！')
      return;
    }
    if(!this.editEmployBasicInfo.residentAddress){
      this.openPopInfo('请输入您的居住地址！')
      return;
    }
    if(!this.editEmployBasicInfo.email){
      this.openPopInfo('请输入您的email！')
      return;
    }else{
      if(!this.lifeCommonService.emailValid(this.editEmployBasicInfo.email)){
        this.openPopInfo('email格式错误！')
        return;
      }
    }
    this.myService.saveBasicInfo(this.editEmployBasicInfo).subscribe((res)=>{
      if(res['success']){
        this.router.navigate(['/work_experience'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
      }else{
        this.openPopInfo(res['message'])
      }
  })
  }


  // 打开弹窗
  openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  // 关闭弹窗
  getPopInfo() {
    this.isNeedAlert = false;
  }
  //   选择地址信息
  selectedArea(type) {
    // this.sendRemoveScrollContent.emit(1);
    if (type === 1) {
      // 户籍地址 
      this.houseFlag = true;
    }
  }

  //  获取地址信息
  getAreaInfo(e, type) {
    // this.sendRemoveScrollContent.emit(0);
    if (type === 1) {
      //  长期居住地
      this.addressInfo = e;
      this.houseFlag = false;
      this.editEmployBasicInfo.provinceId = this.addressInfo.province.id;
      this.editEmployBasicInfo.cityId = this.addressInfo.city.id;
      this.editEmployBasicInfo.provinceName = this.addressInfo.province.value;
      this.editEmployBasicInfo.cityName = this.addressInfo.city.value;
    } 
  }

  //获取城市地址
  provCityQry(){
    this.myService.provCityQry().subscribe((res)=>{
      if(res['success']){
        this.provinces = res['data'].provinces;
      }
    })
  }

}
