import { Component, OnInit,ViewChild,ElementRef } from '@angular/core';
import { MyService } from '../../my.service';
import { ActivatedRoute,Router } from "@angular/router";
import { LifeCommonService } from "../../../common/life-common.service";
import { ChangeDetectorRef } from '@angular/core';
declare const wx: any;
@Component({
  selector: 'ydlife-employee-id-card',
  templateUrl: './employee-id-card.component.html',
  styleUrls: ['./employee-id-card.component.scss']
})
export class EmployeeIdCardComponent implements OnInit {
  @ViewChild('mainScreen') elementView: ElementRef;
  exampleWidth:any;
  exampleHeight:any;
  hiringBasicInfoId:any;
  frontVxUrl:any = null;
  backVxUrl:any = null;
  serverId: any;
  toastDialog: boolean;
  toastInfo: any;
  constructor(private activatedRoute: ActivatedRoute,
    private router: Router,public lifeCommonService:LifeCommonService,
    public myService:MyService,private changeDetectorRef: ChangeDetectorRef) { 
      
    }

  ngOnInit() {
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    setTimeout(() => {
      this.exampleWidth = this.elementView.nativeElement.offsetWidth;
      this.exampleHeight =this.elementView.nativeElement.offsetHeight; 
    }, 300);
    
  }

  next(){
    const param = {
      hiringBasicInfoId:this.hiringBasicInfoId,
      frontVxUrl:this.frontVxUrl,
      backVxUrl:this.backVxUrl
    }
    this.myService.saveBasicInfo(param).subscribe((res)=>{
      if(res['success']){
        this.router.navigate(['/employee_education'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
      }else{
        this.toastDialog = true;
        this.toastInfo = {
          status: 1,
          msg: res['message'],
          timeout: 3000,
          align: 'center'
        };
      }
    })
  }

  selectPic(type){
    // 5.1 拍照、本地选图
    const t = this;
    wx.chooseImage({
      count: 1, // 默认9
      sizeType: ['original', 'compressed'], // 可以指定是原图还是压缩图，默认二者都有
      sourceType: ['album', 'camera'], // 可以指定来源是相册还是相机，默认二者都有
      success: function (res) {
        this.localId = res.localIds[0]; // 返回选定照片的本地ID列表，localId可以作为img标签的src属性显示图片
        const THIS = t;
        wx.uploadImage({
          localId: this.localId, // 需要上传的图片的本地ID，由chooseImage接口获得
          isShowProgressTips: 1, // 默认为1，显示进度提示
          success: function (response) {
            THIS.serverId = response.serverId; // 返回图片的服务器端ID
            const m = {
              mediaId: response.serverId,
              origin: 'ydLife'
            };
            THIS.myService.mediaGet(m).subscribe(async e => {
              if (e['success']) {
                if(type=='front'){
                  THIS.frontVxUrl = e['data']['imgUrl'];
                }
                if(type=='back'){
                  THIS.backVxUrl = e['data']['imgUrl'];
                }
                THIS.changeDetectorRef.markForCheck();
                THIS.changeDetectorRef.detectChanges();
              } else {
                alert(e['message']);
              }
            });
          }
        });
      }
    });
  }
}
