import { Component, OnInit,ViewChild,ElementRef } from '@angular/core';
import { ActivatedRoute,Router } from "@angular/router";
import { MyService } from '../../my.service';
import { LifeCommonService } from "../../../common/life-common.service";

@Component({
  selector: 'ydlife-personal-statement',
  templateUrl: './personal-statement.component.html',
  styleUrls: ['./personal-statement.component.scss']
})
export class PersonalStatementComponent implements OnInit {
  @ViewChild('autofocusFlag') elementView: ElementRef;
  //判断是个人声明还是合同确认
  type:any;
  hiringBasicInfoId:any;
  dropOptionsInfoList:Array<any>;
  isNeedAlert: boolean;
  dialogInfo: any;
  autofocusFlag:boolean;
  dropOptionsInfoListParam:any;
  constructor(private myService: MyService, 
    private activatedRoute: ActivatedRoute,
    public lifeCommonService: LifeCommonService,
    private router: Router) { }

  ngOnInit() {
    this.type = this.activatedRoute.snapshot.data[0]['type'];
    const title = this.activatedRoute.snapshot.data[0]['title'];
    this.lifeCommonService.setTitle(title);
    this.hiringBasicInfoId = this.activatedRoute.snapshot.queryParams.hiringBasicInfoId?this.activatedRoute.snapshot.queryParams.hiringBasicInfoId:null;
    console.log(this.type)
    if(this.type==="personal_statement"){
      this.dropOptionsQuery()
    }
  }

  next(){
    if(this.type == 'personal_statement'){
      this.savePersonalStatements()
      // this.router.navigate(['/contract'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
    }else if(this.type == 'contract'){
      this.router.navigate(['/signature'],{ queryParams: { hiringBasicInfoId:this.hiringBasicInfoId} });
    }
  }

  dropOptionsQuery(){
    this.myService.dropOptionsQuery({code:'EHiring_Personal_Statements'}).subscribe((res)=>{
      if(res['success']){
        this.dropOptionsInfoList = res['data']['dropMasterInfoList'][0]['dropOptionsInfoList'];
      }else{
        this.openPopInfo(res['message'])
      }
    })
  }

   // 打开弹窗
   openPopInfo(message) {
    this.isNeedAlert = true;
    this.dialogInfo = {
      title: null,
      content: { value: message, align: 'center' },
      footer: [{ value: '我知道了', routerLink: '', className: 'weui-dialog__btn_primary' }],
    };
  }

  selectStatements(personalStatements){
    personalStatements.selected = !personalStatements.selected;
    if(personalStatements.id == '241' && personalStatements.selected == true){
      //点击曾经报聘输入报聘自动获取焦点
      this.elementView.nativeElement.focus();
    }
  }

  savePersonalStatements(){
    for(let i=0;i<this.dropOptionsInfoList.length;i++){
      
      this.dropOptionsInfoList[i]['personalStatements'] = this.dropOptionsInfoList[i]['dropOptionName'];
      this.dropOptionsInfoList[i]['personalStatementsId'] = this.dropOptionsInfoList[i]['id'];
      if(this.dropOptionsInfoList[i]['selected'] == true){
        this.dropOptionsInfoList[i]['status'] = 1;
      }else{
        this.dropOptionsInfoList[i]['status'] = 0;
      }
      // this.dropOptionsInfoListParam = this.dropOptionsInfoListParam.push(
      //   {hiringBasicInfoId:this.hiringBasicInfoId,
      //   personalStatements:this.dropOptionsInfoList[i]['dropOptionName'],
      //   personalStatementsId:this.dropOptionsInfoList[i]['id'],
      //   status:this.dropOptionsInfoList[i]['status']
      // }
      // )
    }
    console.log(this.dropOptionsInfoListParam)
  }
  

}
