import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { LifeCommonService } from 'src/app/common/life-common.service';
import { MyService } from '../my.service';

@Component({
  selector: 'ydlife-mine',
  templateUrl: './mine.component.html',
  styleUrls: ['./mine.component.scss']
})
export class MineComponent implements OnInit {
  lifeCustomerInfo: any = JSON.parse(localStorage.getItem('lifeCustomerInfo')) ? JSON.parse(localStorage.getItem('lifeCustomerInfo')) : null;
  public menuLists = [
    {id:1,name:'全部工具',link:'/moreFeatures',params:null},
    {id:2,name:'公司制度',link:'/fileUpload',params:{fileUploadType:'management'}},
    {id:3,name:'新人入口',link:'/newPeople',params:null},
    {id:4,name:'我的薪资',link:'/salary',params:null},
    {id:5,name:'我的积分',link:'/integration',params:null},
  ]
  performanceList:Array<any>;
  performanceSelectedFlag: string = '1';
  onlineInfo: any;
  offlineInfo: any;
  constructor(private lifeCommonService:LifeCommonService,private myService:MyService,private router:Router) { }

  ngOnInit() {
    this.performanceList = [
      { name: `${this.lifeCommonService.dateFormat(new Date, ('M'))}月`, time: 1 },
      { name: `${this.getQuarter(this.lifeCommonService.dateFormat(new Date, ('M')))}`, time: 3 },
      { name: '本年度', time: 2 },
      { name:'往期历史' , time: 4 }
    ]
    //初始化调本月线上 保费+ 本月线下保费
    this.rank(1, 1, 1)
  }

  goDetail(item){
    if(item.link){
      this.router.navigate([item.link])
    }
    if(item.link && item.params){
      this.router.navigate([item.link],{queryParams:item.params})
    }
    
  }

  
  //获取季度
  getQuarter(quarter) {
    if (quarter == '1' || quarter == '2' || quarter == '3') {
      return '第一季度';
    }
    if (quarter == '4' || quarter == '5' || quarter == '6') {
      return '第二季度';
    }
    if (quarter == '7' || quarter == '8' || quarter == '9') {
      return '第三季度';
    }
    if (quarter == '10' || quarter == '11' || quarter == '12') {
      return '第四季度';
    }
  }

    /**
   * time  1-month,2-year,3-季度
   * type 1-保费,2-佣金 3-件数
   * platform //1-online,2-offline
   */
     rank(time, platform, type) {
      this.performanceSelectedFlag = time;
      if(time==4){
        this.router.navigate(['/historical_rank'])
      }else{
        const param = {
          mobileNo: JSON.parse(localStorage.getItem('lifeCustomerInfo'))['mobileNo'],
          time: time,
          platform: platform,
          type: type,
          isPersonal:0
        }
        this.myService.rank(param).subscribe((res) => {
          if (res['success']) {
            if (platform == 1) {
              this.onlineInfo = res['data']['practitionerInfo'];
            }
            if (platform == 2) {
              this.offlineInfo = res['data']['practitionerInfo'];
            }
          }
        });
      }
    }

    jumpToDetail() {
      this.router.navigate(['/rank'], { queryParams: { time: this.performanceSelectedFlag } });
    }

}
