import { defineConfig } from 'vite'
import { createVuePlugin } from 'vite-plugin-vue2'
import path from 'path'

export default defineConfig({
    // 根路径配置，与 Nginx 保持一致
    base: '/',

    plugins: [
        // 配置 Vue 2 插件
        createVuePlugin({
            vueTemplateOptions: {
                compilerOptions: {
                    // 针对 Vue 2 的模板编译选项
                    whitespace: 'condense'
                }
            }
        })
    ],

    resolve: {
        extensions: ['.vue', '.js', '.ts', '.json'],
        alias: {
            // 指向 src 目录（如果你的项目结构有 src 目录）
            '@': path.resolve(__dirname, 'src'),
            '@api': path.resolve(__dirname, 'api'),
            // 确保 Vue 2 正确解析
            'vue': 'vue/dist/vue.runtime.common.js'
        }
    },

    // 开发服务器配置
    server: {
        port: 8080,
        proxy: {
            // 代理后端 API 请求
            '/cffpApi': {
                target: 'http://localhost:8080', // 修改为实际后端地址
                changeOrigin: true,
                rewrite: (path) => path.replace(/^\/cffpApi/, '')
            }
        }
    },

    build: {
        outDir: 'dist',
        assetsDir: 'assets',
        // 生成 manifest 文件，便于追踪资源
        manifest: true,
        // 压缩代码
        minify: 'terser',
        rollupOptions: {
            output: {
                // 自定义输出文件名
                entryFileNames: 'assets/[name].[hash].js',
                chunkFileNames: 'assets/[name].[hash].js',
                assetFileNames: 'assets/[name].[hash].[ext]',

                // 手动分割代码
                manualChunks(id) {
                    if (id.includes('node_modules')) {
                        return 'vendor'; // 将第三方依赖打包到 vendor
                    }
                }
            }
        }
    },

    // 生产环境移除 console
    esbuild: {
        drop: ['console', 'debugger']
    }
})
