import App from './App.vue';
import { createApp } from 'vue'

const app = createApp(App)

// 添加挂载前检查
const rootElement = document.getElementById('app')
if (!rootElement) {
    console.error('⚠️ 未找到挂载元素 #app')
    // 创建备用挂载点
    const fallbackApp = document.createElement('div')
    fallbackApp.id = 'app'
    document.body.appendChild(fallbackApp)
    app.mount('#app')
} else {
    console.log('✅ 找到挂载元素 #app')
    app.mount('#app')
}

// 添加应用加载完成事件
window.addEventListener('DOMContentLoaded', () => {
    console.log('🚀 DOM内容加载完成')
    if (document.getElementById('app').childElementCount === 0) {
        console.warn('⚠️ 应用挂载点为空，可能未正确渲染')
        // 显示错误信息
        const errorDiv = document.createElement('div')
        errorDiv.style = "padding:20px;color:red;font-size:20px;text-align:center;"
        errorDiv.innerHTML = `
            <h1>应用初始化失败</h1>
            <p>请检查控制台错误信息</p>
            <p>当前路径: ${window.location.href}</p>
            <p>Base路径: /cffp/</p>
        `
        document.getElementById('app').appendChild(errorDiv)
    }
})

// H5环境特定代码
if (typeof window !== 'undefined') {
    const firstEntryUrl = window.location.href.split('#')[0]
    window.sessionStorage.setItem('firstEntryUrl', firstEntryUrl)
    console.log('🌐 记录首次访问URL:', firstEntryUrl)
}
