// import $http from "@/common/requestConfig.js"
import request from "./request";
// import {baseURL,apiURL,cffpURL} from "../environments/environment";
// 上传的事件
	export function CommonUpload() {

		return new Promise((resolve, rej) => {
			uni.chooseImage({
				count: 1, //默认9
				sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
				sourceType: ['album'], //从相册选择
				success: function(res) {
					var urlList = []
					// res.tempFiles 数组
					for (var i = 0; i < res.tempFiles.length; i++) {
						uni.showLoading({
							title: '加载中',
							mask: true
						});
						uni.uploadFile({
							url: $http.baseUrl + '/route/appUser/updateImgUrl', // 后端api接口
							filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
							name: 'file', //后端通过'file'获取上传的文件对象
							// formData: this.sendDate,
							// header:{"third-session": uni.getStorageSync('thirdSession')},
							header: {
								// "third-session": uni.getStorageSync('thirdSession')
								'Authorization': 'Bearer' + uni.getStorageSync('access_token')
							},
							success: (res) => {
								//  let data = JSON.parse(res.data)
								// that.headUrl = data.data.link
								let data = JSON.parse(res.data)

								urlList.push({
									url: data.data.link,
									recordId: data.data.recordId
								})
								// 抛出
								resolve(urlList)
								uni.hideLoading();
							}
						});
					}
				}
			});
		})
	}


	export function CommonUploadFile(staffDeptId, type) {
		// type ==1 可以多传照片 
		var sourceType = []
		if(type == 2){
			sourceType = ['camera']
		}else {
			sourceType = ['album', 'camera']
		}
		return new Promise((resolve, rej) => {

			uni.chooseImage({
				count: type== 1?9:1, //默认9
				sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
				sourceType: sourceType, //从相册选择
				success: function(res) {
					
					var urlList = []
					// res.tempFiles 数组
					for (var i = 0; i < res.tempFilePaths.length; i++) {
						uni.showLoading({
							title: '加载中',
							mask: true
						});
						uni.uploadFile({
							url: $http.baseUrl + '/route/fileupload/uploadForLogin', // 后端api接口
							filePath: res.tempFilePaths[i], // uni.chooseImage函数调用后获取的本地文件路劲
							name: 'file', //后端通过'file'获取上传的文件对象
							// formData: this.sendDate,
							formData: { //后台所需除图片外的参数可以写在这里面 ，单张多张都可
								'isAddWaterMaker': true,
								'staffDeptId': staffDeptId,
							},
							header: {
								// "third-session": uni.getStorageSync('thirdSession')
								'Authorization': 'Bearer' + uni.getStorageSync('access_token')
							},
							success: (res1) => {
								console.log(res1, 'aaa')
								let data = JSON.parse(res1.data)
								setTimeout(() => {
									uni.showToast({
										title: '上传成功',
										icon: "none",
										duration: 3000
									})
								}, 30)
								urlList.push({
									url: data.data.link,
									recordId: data.data.recordId
								})
								// 抛出
								if (urlList.length == res.tempFilePaths.length)  resolve(urlList)
								// resolve(data,res.tempFilePaths.length)
								uni.hideLoading();
							}
						});
					}
				}
			});
		})
	}
	// 外勤打开
	export function CommonUploadPng(staffDeptId) {

		return new Promise((resolve, rej) => {
			uni.showLoading({
				title: '加载中',
				mask: true
			});
			uni.uploadFile({
				url: $http.baseUrl + '/route/fileupload/upload', // 后端api接口
				filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
				name: 'file', //后端通过'file'获取上传的文件对象
				// formData: this.sendDate,
				formData: { //后台所需除图片外的参数可以写在这里面 ，单张多张都可
					'isAddWaterMaker': true,
					'staffDeptId': staffDeptId
				},
				// header:{"third-session": uni.getStorageSync('thirdSession')},
				header: {
					// "third-session": uni.getStorageSync('thirdSession')
					'Authorization': 'Bearer' + uni.getStorageSync('access_token')
				},
				success: (res) => {
					let data = JSON.parse(res.data)
					if (data.code == 1) {
						setTimeout(() => {
							uni.showToast({
								title: '上传失败',
								icon: "none",
								duration: 3000
							})
						}, 30)

					} else {
						urlList.push({
							url: data.data.link,
							recordId: data.data.recordId
						})
						// 抛出
						resolve(urlList)
						uni.hideLoading();
					}

				}
			});
		})
	}
