import request from "../util/request";
import {baseURL,apiURL,cffpURL} from "../environments/environment";

export default {
	//查看token是否已经失效
	checkToken(){
		const params = {
			token:uni.getStorageSync('uni-token'),
			ticket:'uni-app'
		}
		return request(`${baseURL}/api/authorize/checkToken`, "POST", params)
	},
	// 获取token
	obtainToken(){
		const params = {
			ticket:'uni-app'
		}
		return request(`${baseURL}/api/authorize/obtainToken`, "POST", params)
	},
	//获取验证码
	verificationCode(params){
		return request(`${baseURL}/api/verificationCode`, "POST", params)
	},
	//登录接口
	loginVerification(params){
		return request(`${cffpURL}/user/loginVerification`, "POST", params)
	},
	//注册接口
	register(params){
		return request(`${cffpURL}/user/register`, "POST", params)
	},
	// 课程查询列表接口
	courseList(params){
		return request(`${cffpURL}/course/list`,"POST",params)
	},
	// 讲师信息查询
	lecturerQuery(params){
		return request(`${apiURL}/college/lecturerQuery`, "POST", params)
	}
	
}
