// import { apiURL } from "../environments/environment";

// /**
//  * 优化后的图片上传方法（支持压缩 + 进度条）
//  * @param {Object} params - 上传参数（同原版）
//  * @returns {Promise} 返回上传结果
//  */
// export function CommonUpload(params) {
//   return new Promise((resolve, reject) => {
//     // 1️⃣ 检查权限（仅APP端需要）
//     // #ifdef APP-PLUS
//     const imageCamera = uni.getStorageSync('imageCamera');
//     if (!imageCamera || imageCamera !== '1') {
//       uni.showModal({
//         title: '权限说明',
//         content: '我们需要访问您的相机和相册，以便您拍摄或上传图片。',
//         confirmText: '同意',
//         cancelText: '拒绝',
//         success: (res) => {
//           if (res.confirm) {
//             uni.setStorageSync('imageCamera', '1');
//             startUpload(params, resolve, reject); // 同意后开始上传
//           } else {
//             reject(new Error('用户拒绝了权限'));
//           }
//         }
//       });
//     } else {
//       startUpload(params, resolve, reject); // 已有权限，直接上传
//     }
//     // #endif

//     // 2️⃣ H5 端直接上传（无需权限）
//     // #ifdef H5
//     startUpload(params, resolve, reject);
//     // #endif
//   });
// }

// /**
//  * 核心上传逻辑（选择图片 → 压缩 → 上传）
//  * @param {Object} params - 上传参数
//  * @param {Function} resolve - Promise resolve
//  * @param {Function} reject - Promise reject
//  */
// function startUpload(params, resolve, reject) {
//   uni.chooseImage({
//     count: 1,
//     sizeType: ['compressed'],
//     sourceType: ['album', 'camera'],
//     success: (chooseRes) => {
//       const tempFilePath = chooseRes.tempFilePaths[0];
//       uni.showLoading({ title: '处理中...', mask: true });

//       // #ifdef MP-WEIXIN
//       uni.compressImage({
//         src: tempFilePath,
//         quality: 70,
//         success: (compressRes) => {
//           uploadFile(compressRes.tempFilePath, params, resolve, reject);
//         },
//         fail: (err) => {
//           uni.hideLoading();
//           reject(new Error('压缩失败: ' + JSON.stringify(err)));
//         },
//       });
//       // #endif

//       // #ifdef H5 || APP-PLUS
//       uploadFile(tempFilePath, params, resolve, reject); // 或者用 canvas 压缩
//       // #endif
//     },
//     fail: (err) => {
//       reject(new Error('选择图片失败: ' + JSON.stringify(err)));
//     },
//   });
// }

// /**
//  * 执行上传操作（带进度条）
//  * @param {String} filePath - 压缩后的图片路径
//  * @param {Object} params - 上传参数
//  * @param {Function} resolve - Promise resolve
//  * @param {Function} reject - Promise reject
//  */
// function uploadFile(filePath, params, resolve, reject) {
//   // 1. 替换原 loading 提示
//   uni.showLoading({ title: '上传中...', mask: true });

//   // 2. 创建上传任务（可监听进度）
//   const uploadTask = uni.uploadFile({
//     url: `${apiURL}/file/upload`,
//     filePath: filePath,
//     name: 'file',
//     formData: { requestVO: JSON.stringify(params) },
//     header: { 'X-Authorization': uni.getStorageSync('uni-token') || '' },
//     success: (res) => {
//       uni.hideLoading();
//       try {
//         const data = JSON.parse(res.data);
//         if (data.success) {
//           resolve(data); // 上传成功
//         } else {
//           reject(new Error(data.message || '上传失败'));
//         }
//       } catch (e) {
//         reject(new Error('解析服务器响应失败'));
//       }
//     },
//     fail: (err) => {
//       uni.hideLoading();
//       reject(new Error('上传失败: ' + JSON.stringify(err)));
//     }
//   });

//   // 3. 监听上传进度（可选，适合大文件）
//   uploadTask.onProgressUpdate((progress) => {
//     console.log(`上传进度: ${progress.progress}%`);
//     // 可以在这里更新 UI，比如：
//     // uni.showToast({ title: `上传中 ${progress.progress}%`, icon: 'none' });
//   });
// }
import request from "./request";
import authorizeUtils from "./authorizeUtils";
import { apiURL } from "../environments/environment";
// 上传图片事件
export function CommonUpload(psrams) {
	let requestVO = psrams
	// @ts-ignore
	return new Promise((resolve, reject) => {
	    // #ifdef APP-PLUS
		  let imageCamera = uni.getStorageSync('imageCamera');
		  if(!imageCamera || imageCamera != '1'){
			 uni.showModal({
				title: '权限说明',
				content: '我们需要访问您的相机和相册，以便您拍摄或上传图片。',
				confirmText: '同意',
				cancelText: '拒绝',
				success: function (res) {
		  		  if (res.confirm) {
			 		uni.setStorageSync('imageCamera', '1');
					uni.chooseImage({
						count: 1, //默认9
						sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
						sourceType: ['album','camera'], //从相册选择
						success: function(res) {
							uni.showLoading({title: '加载中', mask: true});
							uni.uploadFile({
								url: `${apiURL}/file/upload`, // 后端api接口
								filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
								name: 'file', //后端通过'file'获取上传的文件对象
								formData: { requestVO: JSON.stringify(requestVO)},//后台所需除图片外的参数可以写在这里面 ，单张多张都可
								header: {'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''},
								success: (res) => {
									resolve(JSON.parse(res.data));
									uni.hideLoading();
								},
								fail:(err) =>{
									uni.showModal({content:'上传失败', showCancel: false})
									uni.hideLoading();
								}
							});
						}
					});
				  }
				}
			})
		  }else{
			uni.chooseImage({
				count: 1, //默认9
				sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
				sourceType: ['album','camera'], //从相册选择
				success: function(res) {
					uni.showLoading({title: '加载中', mask: true});
					uni.uploadFile({
						url: `${apiURL}/file/upload`, // 后端api接口
						filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
						name: 'file', //后端通过'file'获取上传的文件对象
						formData: { requestVO: JSON.stringify(requestVO)},//后台所需除图片外的参数可以写在这里面 ，单张多张都可
						header: {'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''},
						success: (res) => {
							resolve(JSON.parse(res.data));
							uni.hideLoading();
						},
						fail:(err) =>{
							uni.showModal({content:'上传失败', showCancel: false})
							uni.hideLoading();
						}
					});
				}
			});
		  }
		// #endif
		// #ifdef H5
		uni.chooseImage({
			count: 1, //默认9
			sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
			sourceType: ['album','camera'], //从相册选择
			success: function(res) {
				uni.showLoading({title: '加载中', mask: true});
				uni.uploadFile({
					url: `${apiURL}/file/upload`, // 后端api接口
					filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
					name: 'file', //后端通过'file'获取上传的文件对象
					formData: { requestVO: JSON.stringify(requestVO)},//后台所需除图片外的参数可以写在这里面 ，单张多张都可
					header: {'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''},
					success: (res) => {
						resolve(JSON.parse(res.data));
						uni.hideLoading();
					},
					fail:(err) =>{
						uni.showModal({content:'上传失败', showCancel: false})
						uni.hideLoading();
					}
				});
			}
		});
		// #endif
	})
}

//图片放大
export function ckbigImg(params) {
	wx.previewImage({
		urls: [params], //需要预览的图片http链接列表，多张的时候，url直接写在后面就行了
		current: '', // 当前显示图片的http链接，默认是第一个
		success: function(res) {},
		fail: function(res) {},
		complete: function(res) {},
	})
}

// 这个方法用来上传文件
export function uploadFilepdf(params) {
	let requestVO = params
	// @ts-ignore
	return new Promise((resolve, reject) => {
		uni.chooseFile({
			count: 1, //默认100
			extension: ['.pdf', '.doc'],
			success: function(res) {
				  var str = res.tempFiles[0].name; //截取后4位
				    let a = str.substring(str.length - 3);
					if(a !== 'pdf') {
						uni.showToast({
							title: '上传文件格式不正确！',
							duration: 2000,
							icon: 'none'		
						});
						return
					}
			    var name = 	res.tempFiles[0].name
				uni.showLoading({
					title: '加载中',
					mask: true
				});
				uni.uploadFile({
					url: `${apiURL}/file/upload`, // 后端api接口
					filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
					name: 'file', //后端通过'file'获取上传的文件对象
					formData: {
						requestVO: JSON.stringify(requestVO)
					},
					header: {
						'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''
					},
					success: (res) => {
						let data = JSON.parse(res.data)
						if(data.success == true){
							data.name = name
							resolve(data)
						} else {
							uni.showToast({
								title: '上传失败',
								duration: 2000,
								icon: 'none'		
							});
						}
						uni.hideLoading();
					}
				});
			}
		});
	})
}