import api from "@/api/api";
import dataHandling from './dataHandling'
//只要是未登录状态，想要跳转到名单内的路径时，直接跳到登录页
// 页面白名单，不受拦截
const whiteList = [
	'/myPackageA/login/login',
	'/pages/invitationRegister/invitationlogin',
	'/myPackageA/applyFranchise/applyFranchise',
	'/pages/applyFranchise/applyFranchise',
	'/myPackageA/ruleAndContract/clause',
	'/pages/orderDetail/orderDetail',
	'/pages/courseDetail/courseDetail',
	'/pages/courselist/courselist',
	'/pages/personalCenter/helpCenter',
	'/pages/index/index'
]
export default function initApp(){
	let date = Date.now()
	
	
	uni.addInterceptor('navigateTo', {
	    // 页面跳转前进行拦截, invoke根据返回值进行判断是否继续执行跳转
	    invoke (e) {
			console.log(e);
			let pages = getCurrentPages()
			let pagesLength = pages.length
			
			if(whiteList.indexOf(e.url)==-1&&!uni.getStorageSync('loginType')){
				 uni.clearStorageSync();
				 uni.setStorageSync('loginType','visitor')
				 uni.navigateTo({
				     url: '/myPackageA/login/login'
				 })
			}
			if(uni.getStorageSync('cffp_userId')){
				api.queryInfo({userId:uni.getStorageSync('cffp_userId')}).then(res=>{
					if(!res['success']){
						// 清空全部本地存储
						uni.clearStorageSync();
						uni.setStorageSync('loginType','visitor')
						uni.navigateTo({
						    url: '/myPackageA/login/login'
						})
						return true
					}
					// 保存用户得个人信息
					if (res['success']) {
						const cffp_userInfo = {
							name: res['data']['realName'],
							mobile: res['data']['mobile'],
							partnerType:res['data']['partnerType'],
							nickName:res['data']['nickName'],
						}
						uni.setStorageSync('cffp_userInfo', JSON.stringify(cffp_userInfo))
					}
					
				})
			}
			let whiteArr = ['index','personalCenter','courselist','product']
			// 1. 解析 URL 中的 from 参数
			    const getQueryParam = (url, key) => {
			      const queryString = url.split('?')[1];
			      if (!queryString) return null;
			      const params = new URLSearchParams(queryString);
			      return params.get(key);
			    };
		
			    const fromParam = getQueryParam(e.url, 'from');
	        if(!hasPermission(e.url)){
				// 如果 from 参数在 whiteArr 中，说明是tabbar页带着tabbar的标志参数跳转到登录页，以便未登录状态下回到对应的tabbar页
				      if (fromParam && whiteArr.includes(fromParam)) {
				        uni.redirectTo({
				            url: `/myPackageA/login/login?from=${fromParam}`				        
							})
				      }else {
						  uni.redirectTo({
						      url: '/myPackageA/login/login'
						  })
					  }
	           
	            return false
	        }
			//当页面栈的个数大于10个时，不入页面栈
			if (pagesLength >= 10) {
			  //临时处理，跟换调整方式
			  uni.redirectTo({
			    url: e.url
			  })
			} else {
			  if (date) {
			    //如果时间戳存在 那么记录此页面的停留时间
			    dataHandling.pocessTracking(
			      '停留',
			      `用户在此页面停留${(Date.now() - date) / 1000}秒`,
			      '进入页面后离开页面',
			      2
			    )
			  }
			  date = Date.now()
			}
	        return true
	    },
	    success (e) {}
	})
	uni.addInterceptor('switchTab', {
	  // tabbar页面跳转前进行拦截
	  invoke(e) {
	    if (date) {
	      //如果时间戳存在 那么记录此页面的停留时间
	      dataHandling.pocessTracking(
	        '停留',
	        `用户在此页面停留${(Date.now() - date) / 1000}秒`,
	        '进入页面后离开页面',
	        2
	      )
	    }
	    date = Date.now()
	    return true
	  },
	  success(e) {}
	})
	uni.addInterceptor('reLaunch', {
	  //页面跳转前拦截
	  invoke(e) {
	    if (date) {
	      //如果时间戳存在 那么记录此页面的停留时间
	      dataHandling.pocessTracking(
	        '停留',
	        `用户在此页面停留${(Date.now() - date) / 1000}秒`,
	        '进入页面后离开页面',
	        2
	      )
	    }
	    date = Date.now()
	    return true
	  },
	  //页面跳转后缓存当前页路由
	  success(e) {}
	})
}
function hasPermission (url) {
	let islogin = uni.getStorageSync("isLogin");//在这可以使用token、vuex
	// islogin = Boolean(Number(islogin));//返回布尔值
    // 在白名单中或有登录判断条件可以直接跳转
	
    if(whiteList.indexOf(url.slice(0,url.indexOf('?'))) !== -1 || islogin) {
        return true
    }
    return false
}