import request from "./request";
import { baseURL, apiURL, cffpURL } from "../environments/environment";
// 上传图片事件
export function CommonUpload(psrams) {
	let requestVO = psrams
	// @ts-ignore
	return new Promise((resolve, reject) => {
		uni.chooseImage({
			count: 1, //默认9
			sizeType: ['original', 'compressed'], //可以指定是原图还是压缩图，默认二者都有
			sourceType: ['album','camera'], //从相册选择
			success: function(res) {
				// res.tempFiles 数组
				// for (var i = 0; i < res.tempFiles.length; i++) {
				uni.showLoading({
					title: '加载中',
					mask: true
				});
				uni.uploadFile({
					// /api/file/upload //pc上传代理
					// https://mdev.zuihuibi.cn/api/file/upload
					url: `https://mdev.zuihuibi.cn/api/file/upload`, // 后端api接口
					filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
					name: 'file', //后端通过'file'获取上传的文件对象
					// formData: this.sendDate,
					// header:{"third-session": uni.getStorageSync('thirdSession')},
					formData: { //后台所需除图片外的参数可以写在这里面 ，单张多张都可
						requestVO: JSON.stringify(requestVO)
					},
					header: {
						// "third-session": uni.getStorageSync('thirdSession')
						// 'content-type': 'application/json',
						'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''
					},
					success: (res) => {
						let data = JSON.parse(res.data)
						// // 抛出
						resolve(data)
						uni.hideLoading();
					},
					fail:(err) =>{
						uni.showModal({
							content:'上传失败',
							showCancel: false
						})
						uni.hideLoading();
						// console.log(data, '发生错误,查看错误日志')
					}
				
				});
				// }
			}
		});
	})
}

// 这个方法用来上传文件
export function uploadFilepdf(params) {
	let requestVO = params
	// @ts-ignore
	return new Promise((resolve, reject) => {
		uni.chooseFile({
			count: 1, //默认100
			extension: ['.pdf', '.doc'],
			success: function(res) {
				console.log(res, 5588)
				  var str = res.tempFiles[0].name; //截取后4位
				    let a = str.substring(str.length - 3);
				    console.log(a , 'aaaaaa')
					if(a !== 'pdf') {
						uni.showToast({
							title: '上传文件格式不正确！',
							duration: 2000,
							icon: 'none'		
						});
						return
					}
			    var name = 	res.tempFiles[0].name
				// res.tempFiles 数组
				// for (var i = 0; i < res.tempFiles.length; i++) {
				uni.showLoading({
					title: '加载中',
					mask: true
				});
				uni.uploadFile({
					url: `/api/file/upload`, // 后端api接口
					filePath: res.tempFilePaths[0], // uni.chooseImage函数调用后获取的本地文件路劲
					name: 'file', //后端通过'file'获取上传的文件对象
					formData: {
						requestVO: JSON.stringify(requestVO)
					},
					// header:{"third-session": uni.getStorageSync('thirdSession')},
					header: {
						// "third-session": uni.getStorageSync('thirdSession')
						// 'content-type': 'application/json',
						'X-Authorization': uni.getStorageSync('uni-token') ? uni.getStorageSync('uni-token') : ''
					},
					success: (res) => {
						console.log(res, 54854)
						let data = JSON.parse(res.data)
						if(data.success == true){
							data.name = name
							resolve(data)
						} else {
							uni.showToast({
								title: '上传失败',
								duration: 2000,
								icon: 'none'		
							});
						}
						

						// urlList.push({
						// 	url: data.data.link,
						// 	recordId: data.data.recordId
						// })
						// 抛出
					
						uni.hideLoading();
					}
				});
				// }
			}
		});
	})
}

