import { defineConfig } from 'vite'
import { createVuePlugin } from 'vite-plugin-vue2'
import path from 'path'

export default defineConfig({
    // 路径前缀，与 Nginx 配置匹配
    base: '/',

    plugins: [createVuePlugin()],

    resolve: {
        extensions: ['.vue', '.js', '.ts', '.json'],
        alias: {
            '@': path.resolve(__dirname),
            '@api': path.resolve(__dirname, 'api')
        }
    },

    // // 开发服务器配置
    // server: {
    //     port: 8080,
    //     proxy: {
    //         // 代理后端 API 请求
    //         '/cffpApi': {
    //             target: 'http://localhost:8080',
    //             changeOrigin: true,
    //             rewrite: (path) => path.replace(/^\/cffpApi/, '')
    //         }
    //     }
    // },

    build: {
        outDir: 'dist',  // 输出到 dist 根目录（而非 dist/cffp）
        assetsDir: 'assets',
        rollupOptions: {
            output: {
                entryFileNames: 'assets/[name].[hash].js',
                chunkFileNames: 'assets/[name].[hash].js',
                assetFileNames: 'assets/[name].[hash].[ext]'
            }
        }
    }
})
