import { defineConfig } from 'vite';
import { createVuePlugin } from 'vite-plugin-vue2';
import { fileURLToPath, URL } from 'node:url';

export default defineConfig({
    base: '/cffp/',
    plugins: [
        createVuePlugin({
            // Vue 2 插件配置
            jsx: true, // 启用 JSX 支持
        })
    ],
    resolve: {
        alias: {
            '@': fileURLToPath(new URL('./', import.meta.url)),
            // Vue 2 兼容性别名
            'vue': '@vue/compat',
            '@vue/composition-api': '@vue/composition-api/dist/vue-composition-api.mjs'
        }
    },
    css: {
        preprocessorOptions: {
            scss: {
                additionalData: `@import "@/styles/variables.scss";`
            }
        }
    },
    build: {
        outDir: 'dist',
        assetsDir: 'assets',
        minify: 'terser',
        terserOptions: {
            compress: {
                drop_console: true
            }
        },
        // Vue 2 需要额外的构建配置
        commonjsOptions: {
            transformMixedEsModules: true
        }
    },
    // Vue 2 需要额外的优化配置
    optimizeDeps: {
        include: [
            '@vue/composition-api',
            'element-ui',
            'vue-awesome'
        ]
    }
});
