import { defineConfig } from 'vite'
import { createVuePlugin } from 'vite-plugin-vue2'
import path from 'path'

export default defineConfig({
    // 根路径配置，与 Nginx 保持一致
    base: '/',

    plugins: [
        // 配置 Vue 2 插件
        createVuePlugin({
            vueTemplateOptions: {
                compilerOptions: {
                    // 针对 Vue 2 的模板编译选项
                    whitespace: 'condense'
                }
            }
        })
    ],

    resolve: {
        extensions: ['.vue', '.js', '.ts', '.json'],
        alias: {
            '@': path.resolve(__dirname),
            '@api': path.resolve(__dirname, 'api'),
            // 确保 Vue 2 正确解析
            'vue': 'vue/dist/vue.runtime.common.js'
        }
    },

    // 开发服务器配置
    server: {
        port: 8080,
        proxy: {
            // 代理后端 API 请求
            '/cffpApi': {
                target: 'http://localhost:8080', // 修改为实际后端地址
                changeOrigin: true,
                rewrite: (path) => path.replace(/^\/cffpApi/, '')
            }
        }
    },

    build: {
        outDir: 'dist',
        assetsDir: 'assets',
        // 生成 manifest 文件，便于追踪资源
        manifest: true,
        // 压缩代码
        minify: 'terser',
        // 禁用哈希和合并
        rollupOptions: {
            output: {
                entryFileNames: '[name].js',
                chunkFileNames: '[name].js',
                assetFileNames: '[name].[ext]', // 保持原名
                manualChunks: null // 禁用依赖合并
            }
        }
    },

    // 生产环境移除 console
    esbuild: {
        drop: ['console', 'debugger']
    }
})
