// vite.config.mjs
import { defineConfig } from 'vite';
import vue from '@vitejs/plugin-vue';
import { fileURLToPath, URL } from 'node:url';

export default defineConfig({
    plugins: [vue({/* 自定义元素配置 */})],
    resolve: {
        alias: { '@': fileURLToPath(new URL('./', import.meta.url)) }
    },
    css: {
        preprocessorOptions: {
            scss: {
                additionalData: `@import "@/styles/variables.scss";`  // 全局注入变量 [6]
            }
        }
    },
    build: {
        minify: 'terser',
        terserOptions: {
            compress: {
                drop_console: true  // 生产环境移除 console [10]
            }
        }
    }
});
