if (typeof Promise !== "undefined" && !Promise.prototype.finally) {
  Promise.prototype.finally = function(callback) {
    const promise = this.constructor;
    return this.then((value) => promise.resolve(callback()).then(() => value), (reason) => promise.resolve(callback()).then(() => {
      throw reason;
    }));
  };
}
;
if (typeof uni !== "undefined" && uni && uni.requireGlobal) {
  const global = uni.requireGlobal();
  ArrayBuffer = global.ArrayBuffer;
  Int8Array = global.Int8Array;
  Uint8Array = global.Uint8Array;
  Uint8ClampedArray = global.Uint8ClampedArray;
  Int16Array = global.Int16Array;
  Uint16Array = global.Uint16Array;
  Int32Array = global.Int32Array;
  Uint32Array = global.Uint32Array;
  Float32Array = global.Float32Array;
  Float64Array = global.Float64Array;
  BigInt64Array = global.BigInt64Array;
  BigUint64Array = global.BigUint64Array;
}
;
if (uni.restoreGlobal) {
  uni.restoreGlobal(Vue, weex, plus, setTimeout, clearTimeout, setInterval, clearInterval);
}
(function(vue) {
  "use strict";
  function formatAppLog(type, filename, ...args) {
    if (uni.__log__) {
      uni.__log__(type, filename, ...args);
    } else {
      console[type].apply(console, [...args, filename]);
    }
  }
  var _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };
  const _sfc_main$1 = {
    data() {
      return {
        loginType: "codelogin",
        passwordFlag: false,
        loginTypeName: "\u9A8C\u8BC1\u7801\u767B\u5F55",
        countdown: 60,
        sedCode: "\u83B7\u53D6\u9A8C\u8BC1\u7801"
      };
    },
    methods: {
      formReset: function(e) {
        formatAppLog("log", "at components/login/login.vue:69", "\u6E05\u7A7A\u6570\u636E");
      },
      getLogin() {
        this.loginType === "codelogin" ? this.loginType = "pwlogin" : this.loginType = "codelogin";
        this.loginTypeName = this.loginType == "codelogin" ? "\u9A8C\u8BC1\u7801\u767B\u5F55" : "\u5BC6\u7801\u767B\u5F55";
      },
      register() {
        this.loginType = "register";
        this.loginTypeName = "\u6CE8\u518C";
      },
      sendMessage() {
        this.delayTime();
      },
      delayTime() {
        if (this.countdown == 0) {
          this.isValid = false;
          this.sedCode = "\u91CD\u65B0\u53D1\u9001";
          this.countdown = 60;
        } else {
          this.isValid = true;
          this.sedCode = this.countdown + "s";
          this.countdown--;
          setTimeout(() => {
            this.delayTime();
          }, 1e3);
        }
      }
    }
  };
  function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("view", { class: "wrapper" }, [
      vue.createElementVNode("view", { class: "logo" }, [
        vue.createElementVNode("img", {
          src: "/static/logo.png",
          alt: "logo",
          srcset: ""
        }),
        vue.createElementVNode("view", null, "\u6B22\u8FCE\u767B\u5F55\u4F7F\u7528CFFP")
      ]),
      vue.createElementVNode("view", { class: "content" }, [
        vue.createElementVNode("view", { class: "login_title" }, vue.toDisplayString($data.loginTypeName), 1),
        vue.createElementVNode("form", null, [
          $data.loginType === "register" ? (vue.openBlock(), vue.createElementBlock("view", {
            key: 0,
            class: "inputItem"
          }, [
            vue.createElementVNode("input", {
              class: "uni-input",
              name: "invitationCode",
              placeholder: "\u8F93\u5165\u9080\u8BF7\u7801(\u975E\u5FC5\u586B)"
            })
          ])) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode("view", { class: "inputItem" }, [
            vue.createElementVNode("input", {
              class: "uni-input",
              name: "mobileNo",
              placeholder: "\u8F93\u5165\u624B\u673A\u53F7"
            })
          ]),
          $data.loginType === "codelogin" || $data.loginType === "register" ? (vue.openBlock(), vue.createElementBlock("view", {
            key: 1,
            class: "inputItem"
          }, [
            vue.createElementVNode("input", {
              class: "uni-input",
              name: "code",
              placeholder: "\u8F93\u5165\u9A8C\u8BC1\u7801"
            }),
            vue.createElementVNode("text", {
              onClick: _cache[0] || (_cache[0] = ($event) => $options.sendMessage())
            }, vue.toDisplayString($data.sedCode), 1)
          ])) : vue.createCommentVNode("v-if", true),
          $data.loginType === "pwlogin" || $data.loginType === "register" ? (vue.openBlock(), vue.createElementBlock("view", {
            key: 2,
            class: "inputItem"
          }, [
            !$data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("input", {
              key: 0,
              class: "uni-input",
              type: "text",
              name: "password",
              placeholder: "\u8F93\u5165\u5BC6\u7801"
            })) : vue.createCommentVNode("v-if", true),
            $data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("input", {
              key: 1,
              class: "uni-input",
              type: "text",
              password: "",
              name: "password",
              placeholder: "\u8F93\u5165\u5BC6\u7801"
            })) : vue.createCommentVNode("v-if", true),
            $data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("text", {
              key: 2,
              onClick: _cache[1] || (_cache[1] = ($event) => $data.passwordFlag = false)
            }, "\u663E\u793A\u5BC6\u7801")) : vue.createCommentVNode("v-if", true),
            !$data.passwordFlag ? (vue.openBlock(), vue.createElementBlock("text", {
              key: 3,
              onClick: _cache[2] || (_cache[2] = ($event) => $data.passwordFlag = true)
            }, "\u4E0D\u663E\u793A\u5BC6\u7801")) : vue.createCommentVNode("v-if", true)
          ])) : vue.createCommentVNode("v-if", true)
        ]),
        vue.createElementVNode("view", { class: "agree" }, [
          vue.createElementVNode("icon", {
            type: _ctx.radioUnselect,
            size: "26"
          }, null, 8, ["type"]),
          vue.createElementVNode("text", null, "\u5DF2\u9605\u8BFB\u5E76\u540C\u610F"),
          vue.createElementVNode("a", { href: "#" }, "\u94F6\u76FE\u4FDD\u9669\u7ECF\u7EAA\u670D\u52A1\u534F\u8BAE"),
          vue.createElementVNode("text", null, "\u548C"),
          vue.createElementVNode("a", { href: "" }, "\u9690\u79C1\u653F\u7B56")
        ]),
        vue.createElementVNode("view", { class: "login_btn" }, vue.toDisplayString($data.loginType == "register" ? "\u6CE8\u518C" : "\u767B\u5F55"), 1),
        vue.createElementVNode("view", { class: "login_type" }, [
          vue.createElementVNode("text", {
            onClick: _cache[3] || (_cache[3] = ($event) => $options.getLogin())
          }, vue.toDisplayString($data.loginType == "pwlogin" || $data.loginType == "register" ? "\u9A8C\u8BC1\u7801\u767B\u5F55" : "\u5BC6\u7801\u767B\u5F55"), 1),
          vue.createElementVNode("text", {
            onClick: _cache[4] || (_cache[4] = ($event) => $options.register())
          }, vue.toDisplayString($data.loginType == "codelogin" ? "\u7ACB\u5373\u6CE8\u518C" : "\u5FD8\u8BB0\u5BC6\u7801"), 1)
        ]),
        vue.createElementVNode("view", null, [
          vue.createElementVNode("view", { class: "other_login" }, [
            vue.createElementVNode("text", { class: "text_line" }),
            vue.createElementVNode("text", { style: { "margin": "0 40rpx", "position": "relative", "top": "10rpx" } }, "\u5176\u4ED6\u767B\u5F55"),
            vue.createElementVNode("text", { class: "text_line" })
          ]),
          vue.createElementVNode("view", { class: "login_type" }, [
            vue.createElementVNode("text", null, "\u6E38\u5BA2"),
            vue.createElementVNode("text", null, "\u4EE3\u7406\u5546")
          ])
        ])
      ])
    ]);
  }
  var ComponentsLoginLogin = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render], ["__file", "E:/work/cffp/components/login/login.vue"]]);
  __definePage("components/login/login", ComponentsLoginLogin);
  const _sfc_main = {
    onLaunch: function() {
      formatAppLog("log", "at App.vue:4", "App Launch");
    },
    onShow: function() {
      formatAppLog("log", "at App.vue:7", "App Show");
    },
    onHide: function() {
      formatAppLog("log", "at App.vue:10", "App Hide");
    }
  };
  var App = /* @__PURE__ */ _export_sfc(_sfc_main, [["__file", "E:/work/cffp/App.vue"]]);
  function createApp() {
    const app = vue.createVueApp(App);
    return {
      app
    };
  }
  const { app: __app__, Vuex: __Vuex__, Pinia: __Pinia__ } = createApp();
  uni.Vuex = __Vuex__;
  uni.Pinia = __Pinia__;
  __app__.provide("__globalStyles", __uniConfig.styles);
  __app__._component.mpType = "app";
  __app__._component.render = () => {
  };
  __app__.mount("#app");
})(Vue);
