// vite.config.js
import { defineConfig } from 'vite'
import { createVuePlugin } from 'vite-plugin-vue2'
import path from 'path'

export default defineConfig({
    plugins: [createVuePlugin()],
    resolve: {
        extensions: ['.vue', '.js', '.ts', '.json'], // 添加 .ts 支持
        alias: {
            '@': path.resolve(__dirname), // 指向项目根目录
            '@api': path.resolve(__dirname, 'api') // 直接指向 api 目录
        }
    }
})
