// var wx = require("weixin-js-sdk/index.js") //引入刚下载的js文件
// import $H from '@/api/request.js' //封装好的接口请求

// import wx from 'weixin-js-sdk'
import api from "../api/api";
import {companyInfo,baseURL,shareURL} from "@/environments/environment";
let userInfo = {name:''}
if(uni.getStorageSync('cffp_userInfo')){
			userInfo = JSON.parse(uni.getStorageSync('cffp_userInfo'))
	}
	
// 初始化SDK
export function initJssdkShare(callback, url) {
  const WxConfigRequestVO = {
    url: url,
    systemType: uni.getStorageSync('addSystemType') || '1'
  };

  api.Wxshare(WxConfigRequestVO).then(res => {
    jWeixin.config({
      debug: false, // 生产环境关闭调试
      appId: res.data.appId,
      timestamp: res.data.timestamp,
      nonceStr: res.data.nonceStr,
      signature: res.data.signature,
      jsApiList: ['updateAppMessageShareData', 'updateTimelineShareData', 'onMenuShareAppMessage']
    });

    jWeixin.ready(() => {
      console.log('微信SDK初始化完成');
      if (callback) callback();
    });

    jWeixin.error(err => {
      console.error('微信SDK初始化失败', err);
    });
  });
}

// 设置微信分享内容（不自动覆盖，需手动调用）
export function setWechatShare(data) {
	console.log('分享data',data);
  if (!jWeixin) {
    console.error('微信SDK未初始化');
    return;
  }
  if(!data){
	  const currentUrl = `${shareURL}/pages/index/index`;
	 data = {
	    title: '成为银盾合伙人，分享商品赚不停',
	    // desc: `${userInfo.name || ''}邀您加入【家庭财策师联盟】，资源+伙伴，共赢未来！`,
		desc: `资源+伙伴，共赢未来！`,
	    link: currentUrl,
	    imgUrl: `${shareURL}/static/images/shareBg.png`
	};
  }
  jWeixin.ready(() => {
    // 新API（推荐）
    jWeixin.updateAppMessageShareData({
      title: data.title,
      desc: data.desc,
      link: data.link,
      imgUrl: data.imgUrl,
      success: () => console.log('好友分享设置成功')
    });
    
    jWeixin.updateTimelineShareData({
      title: data.title,
      link: data.link,
      imgUrl: data.imgUrl,
      success: () => console.log('朋友圈分享设置成功')
    });
    
    // 旧API（兼容）
    jWeixin.onMenuShareAppMessage({
      title: data.title,
      desc: data.desc,
      link: data.link,
      imgUrl: data.imgUrl,
      success: () => console.log('旧版分享设置成功')
    });
  });
}
	// data是穿的参数 url是当前页面的链接
	export function hshare(data,url){
		console.log('data,url',data,url);
		 // 确保分享的链接不包含时间戳
		 
		// initJssdkShare(data, url)
		initJssdkShare(function(){
			jWeixin.ready(function(){
				var sharedata={
					title: data.title, //标题
					desc: data.desc, //描述
					link: data.link ,//分享链接
					imgUrl:data.imgUrl, //图片
					success:(res=>{
					})
				};
				jWeixin.updateAppMessageShareData(sharedata)//自定义微信分享给朋友
				jWeixin.updateTimelineShareData(sharedata);//自定义微信分享给朋友
				jWeixin.onMenuShareAppMessage(sharedata);//获取“分享给朋友”按钮点击状态及自定义分享内容接口（即将废弃）
			})
		},url)
	}
	
	
	
// 新的分享方法  直接调起微信好友弹窗
// 设置微信分享内容并直接调起分享
export function setWechatShareDirectly(data) {
  if (!jWeixin) {
    console.error('微信SDK未初始化');
    return;
  }
  
  if(!data){
    const currentUrl = `${shareURL}/pages/index/index`;
    data = {
      title: '成为银盾合伙人，分享商品赚不停',
      desc: `资源+伙伴，共赢未来！`,
      link: currentUrl,
      imgUrl: `${shareURL}/static/images/shareBg.png`
    };
  }
  
  jWeixin.ready(() => {
    // 尝试直接调起分享
    try {
      // 注意：此接口需要特定权限，普通公众号可能无法使用
      jWeixin.invoke('shareWechatMessage', {
        title: data.title,
        desc: data.desc,
        link: data.link,
        imgUrl: data.imgUrl
      }, function(res) {
        if(res.err_msg === 'shareWechatMessage:ok') {
          console.log('分享成功');
        } else {
          //  fallback 到常规分享设置
          setWechatShare(data);
        }
      });
    } catch (e) {
      console.error('直接调起分享失败，使用常规分享', e);
      // 常规分享设置
      jWeixin.updateAppMessageShareData({
        title: data.title,
        desc: data.desc,
        link: data.link,
        imgUrl: data.imgUrl,
        success: () => console.log('好友分享设置成功')
      });
    }
  });
}