/// <reference types="uni-app" />
import { UniPlatforms } from "../utils/platform";
import { BuiltInPainterElementOption } from "./painter-element/index";
import { PainterContext } from "./painter-context/index";
interface IPanterOption {
    platform?: UniPlatforms;
    upx2px?: (upx: number) => number;
}
/** 单次绘制选项 */
interface IDrawOption {
}
export default class Painter {
    ctx: PainterContext;
    upx2px: NonNullable<IPanterOption["upx2px"]>;
    platform: NonNullable<IPanterOption["platform"]>;
    constructor(ctx: CanvasContext, { platform, upx2px }?: IPanterOption);
    draw(elementOption: BuiltInPainterElementOption, drawOption?: IDrawOption): Promise<import("./value").Size>;
    /** 创建元素对象 */
    createElement(elementOption: BuiltInPainterElementOption): import("./painter-element/element-text").PainterTextElement | import("./painter-element/element-text-block").PainterTextBlockElement | import("./painter-element/element-image").PainterImageElement | import("./painter-element/element-line").PainterLineElement | import("./painter-element/element-rect").PainterRectagleElement | import("./painter-element/element-container").PainterContainerElement | import("./painter-element/element-clip").PainterClipElement | import("./painter-element/element-transform").PainterTransformElement;
    /** 获取指定元素的内部尺寸, 结果不包含元素的 left 和 top */
    layout(elementOption: BuiltInPainterElementOption): Promise<import("./value").Size>;
    /** 兼容将 painter 实例保存在 uniapp this 上, 勿手动调用 */
    toJSON(): string;
}
export {};
