import router from './router'
import store from './store'
import { Message } from 'element-ui'
import NProgress from 'nprogress' // progress bar
import 'nprogress/nprogress.css' // progress bar style
import { getToken, setToken, removeToken } from '@/utils/auth' // get token from cookie
import getPageTitle from '@/utils/get-page-title'
NProgress.configure({ showSpinner: false }) // NProgress Configuration

store.dispatch('settings/getSystemSettings')

const whiteList = ['/login', '/auth-redirect'] // no redirect whitelist

router.beforeEach(async(to, from, next) => {
  function getQueryParam(name) {
    // 获取hash后的部分（包括路径和参数）
    const hash = window.location.hash
    // 找到问号位置
    const queryIndex = hash.indexOf('?')

    if (queryIndex !== -1) {
      const queryStr = hash.substring(queryIndex + 1)
      const params = new URLSearchParams(queryStr)
      return params.get(name)
    }
    return null
  }

  const token = getQueryParam('token')
  const hiddenSidler = getQueryParam('hiddenSidler')
  if (token) {
    removeToken()
    store.dispatch('user/setToken', token)
    store.dispatch('user/setHiddenSidler', hiddenSidler)
    setToken(token)
  }
  // const newhiddenSidler = store.state.user.hiddenSidler
  // console.log(newhiddenSidler)

  // start progress bar
  NProgress.start()

  // set page title
  document.title = getPageTitle(to.meta.title, store.state.settings.title)

  // determine whether the user has logged in
  const hasToken = getToken()
  if (hasToken) {
    if (to.path === '/login') {
      // if is logged in, redirect to the home page
      next({ path: '/' })
      NProgress.done()
    } else {
      // determine whether the user has obtained his permission roles through getInfo
      const hasRoles = store.getters.roles && store.getters.roles.length > 0
      if (hasRoles) {
        next()
      } else {
        try {
          // get user info
          // note: roles must be a object array! such as: ['admin'] or ,['developer','editor']
          const { roles } = await store.dispatch('user/getInfo')

          // generate accessible routes map based on roles
          const accessRoutes = await store.dispatch('permission/generateRoutes', roles)

          // dynamically add accessible routes
          router.addRoutes(accessRoutes)

          // hack method to ensure that addRoutes is complete
          // set the replace: true, so the navigation will not leave a history record
          next({ ...to, replace: true })
        } catch (error) {
          // remove token and go to login page to re-login
          // await store.dispatch('user/resetToken')
          Message.error(error || 'Has Error')
          next(`/login?redirect=${to.path}`)
          NProgress.done()
        }
      }
    }
  } else {
    /* has no token*/

    if (whiteList.indexOf(to.path) !== -1) {
      // in the free login whitelist, go directly
      next()
    } else {
      // other pages that do not have permission to access are redirected to the login page.
      next(`/login?redirect=${to.path}`)
      NProgress.done()
    }
  }
})

router.afterEach(() => {
  // finish progress bar
  NProgress.done()
})
