import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core'
@Component({
  selector: 'app-page13',
  templateUrl: './page13.component.html',
  styleUrls: ['./page13.component.css']
})
export class Page13Component implements OnInit {
  @Input() curPageData: Array<any>
  @Output() getAllAnswer = new EventEmitter<any>()
  allOptions: Array<any>
  constructor() {}

  ngOnInit() {
    this.allOptions = []
    this.getAlloptions()
  }
  getAnswer(options) {
    options['selected'] = !options['selected']
    for (let i = 0; i < this.allOptions.length; i++) {
      // 更改问题状态，防止重复往数组push
      if (options['optionId'] == this.allOptions[i]['optionId']) {
          let index = this.allOptions.indexOf(this.allOptions[i])
          if (index > -1) {
            this.allOptions.splice(index, 1)
          } 
      }
    }
    this.allOptions.push(options)
    for (let i = 0; i < this.allOptions.length; i++) {
      let index;
            // 当选中无疾病时
            if(options['optionId']==99 && options['selected']==true){
              index = this.allOptions.indexOf(options);
              this.allOptions[i]['selected'] = false;
              if(index > -1){
                this.allOptions[index]['selected'] = true;
              }
            }else{
              // 选中其他疾病时，无疾病状态改为false
              if(this.allOptions[i]['optionId']==99){
                this.allOptions[i]['selected'] = false;
              }
            }
    }
    const ret = {
      // ...this.curPageData,
      pageId: this.curPageData['pageId'],
      questions: [
        {
          ...this.curPageData['questions'][0],
          questionId: this.curPageData['questions'][0].questionId,
          options: this.filterItems()
        }
      ]
    }
    this.getAllAnswer.emit(ret)
  }
  filterItems() {
    return this.allOptions.filter(item=> {
        return item['selected']==true;
    })
  }
  getAlloptions(){
    const questions = this.curPageData['questions']
    if(!questions){
      return
    }
    questions[0]['options'].forEach(option => {
      if(option['selected']){
        this.allOptions.push(option)
      }
    });
  }
}
