import { Component, OnInit,Input, Output, EventEmitter} from '@angular/core';

@Component({
  selector: 'app-page15',
  templateUrl: './page15.component.html',
  styleUrls: ['./page15.component.css']
})
export class Page15Component implements OnInit {
  @Input() curPageData: Array<any>
  @Output() getAllAnswer = new EventEmitter<any>()
  curQues: Object
  curAllQues: Object
  optionType:number
  selectedObj:Object;
  allOptions: Array<any>
  constructor() { }

  ngOnInit() {
    // console.log(this.curPageData)
    //拿到数据中是多选还是单选2表示多选1表示单选
    this.optionType = this.curPageData['questions'][0].optionType
    // console.log(this.optionType)
    if(this.optionType==1){
      this.selectedObj = {}
      this.setOptionSelected()
    }
    if(this.optionType==2){
      this.allOptions = []
      this.getAlloptions()
    }
  }

  getManyAnswer(options) {
    // console.log(options)
    options['selected'] = !options['selected']
    for (let i = 0; i < this.allOptions.length; i++) {
      // 更改问题状态，防止重复往数组push
      if (options['optionId'] == this.allOptions[i]['optionId']) {
          let index = this.allOptions.indexOf(this.allOptions[i])
          if (index > -1) {
            this.allOptions.splice(index, 1)
          } 
      }
    }
    this.allOptions.push(options)
    for (let i = 0; i < this.allOptions.length; i++) {
      let index;
            // 当选中无疾病时
            if(options['optionId']==117 && options['selected']==true){
              index = this.allOptions.indexOf(options);
              this.allOptions[i]['selected'] = false;
              if(index > -1){
                this.allOptions[index]['selected'] = true;
              }
            }else{
              // 选中其他疾病时，无疾病状态改为false
              if(this.allOptions[i]['optionId']==117){
                this.allOptions[i]['selected'] = false;
              }
            }
    }
    const ret = {
      // ...this.curPageData,
      pageId: this.curPageData['pageId'],
      questions: [
        {
          ...this.curPageData['questions'][0],
          questionId: this.curPageData['questions'][0].questionId,
          options: this.filterItems()
        }
      ]
    }
    this.getAllAnswer.emit(ret)
  }

  filterItems() {
    return this.allOptions.filter(item=> {
        return item['selected']==true;
    })
  }

  //单选调用的方法
  getAnswer(options) {
    if(!this.selectedObj['selected']){
      this.selectedObj = options
      options['selected'] = true;
    }else{
      if(this.selectedObj['optionId']!=options.optionId){
        this.selectedObj['selected'] = false;
        options['selected'] = true;
        this.selectedObj = options
      }
    }
    const ret = {
      pageId: this.curPageData['pageId'],
      questions: [
        {
          questionId: this.curPageData['questions'][0].questionId,
          options: [options]
        }
      ]
    }
    this.getAllAnswer.emit(ret)
  }

  setOptionSelected() {
    const options = this.curPageData['questions'][0].options
    // console.log(this.curPageData['questions'][0])
    if (!options) {
      return
    }
     options.forEach(option => {
        if (option['selected']) {
          this.selectedObj = option
        }
      })
  }

  //判断用哪个方法
  checkFun(options){
    if(this.optionType==1){
      this.getAnswer(options)
    }
    if(this.optionType==2){
      this.getManyAnswer(options)
    }
  }

  getAlloptions(){
    const questions = this.curPageData['questions']
    if(!questions){
      return
    }
    questions[0]['options'].forEach(option => {
      if(option['selected']){
        this.allOptions.push(option)
      }
    });
  }
  
}
