import { Component, OnInit } from '@angular/core';
import { CommonService } from '../common.service';
import {environment} from "../../environments/environment";
@Component({
  selector: 'app-transit3',
  templateUrl: './transit3.component.html',
  styleUrls: ['./transit3.component.css']
})
export class Transit3Component implements OnInit {
  activityCode: string;
  constructor(
    public commonService: CommonService
  ) {
  }

  ngOnInit() {
    this.activityCode = sessionStorage.getItem('activityCode');
  }

  getHref() {
    if (this.activityCode == 'mmh') {
      window.location.href = `${environment.hostName}/questionnaire/#/specialMmh`;
    } else {
      window.location.href = `${environment.hostName}/member`;
    }
  }
}
