import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core'

@Component({
  selector: 'app-page3',
  templateUrl: './page3.component.html',
  styleUrls: ['./page3.component.css']
})
export class Page3Component implements OnInit {
  @Input() curPageData: Array<any>
  @Input() isShowChildAgeBtn: boolean
  @Output() getAllAnswer = new EventEmitter<any>()

  isShow: boolean
  curQues: Object
  curAllQues: Object
  constructor() {}

  ngOnInit() {
    this.curQues = {}
    this.curAllQues = {}

    console.log(this.curPageData)
  }
  showToast(question) {
    this.isShow = true
    this.curQues = question
    console.log(this.curQues)
  }
  closeToast() {
    this.isShow = false
  }
  getAnswer(option) {
    const questionId = this.curQues['questionId']
    this.curAllQues[questionId] = option
    const questions = Object.keys(this.curAllQues).map(questionId => {
      return { questionId, options: this.curAllQues[questionId] }
    })
    const ret = {
      pageId: 3,
      questions
    }
    this.getAllAnswer.emit(ret)
  }
}
