import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core'

@Component({
  selector: 'app-page8',
  templateUrl: './page8.component.html',
  styleUrls: ['./page8.component.css']
})
export class Page8Component implements OnInit {
  @Input() curPageData: Array<any>
  @Output() getAllAnswer = new EventEmitter<any>()
  curAllQues: Object
  selectedNum: number
  selectedTwo: number
  selectedObj: Object
  constructor() {}

  ngOnInit() {
    this.curAllQues = {}
    this.selectedObj = {}
    this.setOptionSelected()
    // console.log(this.curPageData)
  }
  getAnswer(question, options) {
    const questionId = question['questionId']
    if (!this.selectedObj[questionId]) {
      this.selectedObj[questionId] = options
      options['selected'] = true
    } else {
      if (this.selectedObj[questionId].optionId != options.optionId) {
        this.selectedObj[questionId]['selected'] = false
        options['selected'] = true
        this.selectedObj[questionId] = options
      }
    }
    this.curAllQues[questionId] = options
    const questions = Object.keys(this.curAllQues).map(questionId => {
      return { questionId, options: [this.curAllQues[questionId]] }
    })
    const ret = {
      pageId: 8,
      questions
    }
    // console.log(this.curPageData['questions']);
    // console.log(ret.questions)
    this.getAllAnswer.emit(ret)
  }
  setOptionSelected() {
    const questions = this.curPageData['questions']
    if (!questions) {
      return
    }
    questions.map(question => {
      question['options'].forEach(option => {
        if (option['selected']) {
          this.selectedObj[question['questionId']] = option
          const questions = Object.keys(this.curAllQues).map(questionId => {
            return { questionId, options: [this.curAllQues[questionId]] }
          })
          const ret = {
            pageId: 8,
            questions
          }
          this.getAllAnswer.emit(ret)
        }
      })
    })
  }
}
