import {Component, OnInit} from '@angular/core';
import {EventBusService} from '../event-bus.service';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'app-broker-detail',
  templateUrl: './broker-detail.component.html',
  styleUrls: ['./broker-detail.component.css']
})
export class BrokerDetailComponent implements OnInit {
  certificateList: Array<any>;
  lifePhotoList: Array<any>;
  practitionerId: any;
  userPractitionerInfo: any;

  constructor(private eventBusService: EventBusService, private activatedRoute: ActivatedRoute) {
  }

  ngOnInit() {
    this.practitionerId = this.activatedRoute.snapshot.params['id'];
    this.userPractitionerDetailQuery();
  }

  userPractitionerDetailQuery() {
    const practitionerId = {
      practitionerId: this.practitionerId
    };
    this.eventBusService.userPractitionerDetailQuery(practitionerId).then(res => {
      if (res['success']) {
        this.userPractitionerInfo = res['data'];
        this.certificateList = this.userPractitionerInfo.certificateList;
        this.lifePhotoList = this.userPractitionerInfo.lifePhotoList;
      }
    });
  }

}
