import {Component, OnInit} from '@angular/core';
import {CommonService} from "./common.service";

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent implements OnInit {

  constructor(private commonService: CommonService) {
  }

  ngOnInit() {
    const customerId = this.commonService.getQueryString('customerId');
    const orderId = this.commonService.getQueryString('orderId');
    const campaignInfo = {
        campaignCode: this.commonService.getQueryString('campaign'),
        campaignTaskCode: this.commonService.getQueryString('task'),
      } || null;
    sessionStorage.setItem('customerId', customerId);
    sessionStorage.setItem('orderId', orderId);
    if (!campaignInfo) {
      sessionStorage.setItem('campaignInfo', JSON.stringify(campaignInfo));
    }
  }
}
