import {NgModule, Component} from '@angular/core';
import {Routes, RouterModule} from '@angular/router';
import {TransitComponent} from './transit/transit.component';
import {FamilyComponent} from './family/family.component';
import {AgeComponent} from './age/age.component';
import {JobComponent} from './job/job.component';
import {IncomeComponent} from './income/income.component';
import {LoanComponent} from './loan/loan.component';
import {SocialSecurityComponent} from './social-security/social-security.component';
import {HealthComponent} from './health/health.component';
import {ChildrenHealthComponent} from './children-health/children-health.component';
import {DiseaseComponent} from './disease/disease.component';
import {SmokingComponent} from './smoking/smoking.component';
import {LiveComponent} from './live/live.component';
import {Transit1Component} from './transit1/transit1.component';
import {Transit2Component} from './transit2/transit2.component';
import {Transit3Component} from './transit3/transit3.component';

import {CommonModule} from '@angular/common';

const routes: Routes = [
  {
    path: '',
    redirectTo: '/index',
    pathMatch: 'full'
  }, {
    path: 'index',
    component: TransitComponent
  }, {
    path: 'family',
    component: FamilyComponent
  }, {
    path: 'age',
    component: AgeComponent
  }, {
    path: 'job',
    component: JobComponent,
    data: [{id: 1}]
  }, {
    path: 'spouse_job',
    component: JobComponent,
    data: [{id: 2}]
  }
  , {
    path: 'income',
    component: IncomeComponent
  }, {
    path: 'loan',
    component: LoanComponent
  }, {
    path: 'social',
    component: SocialSecurityComponent
  }, {
    path: 'health',
    component: HealthComponent,
    data: [{id: 1}]
  }, {
    path: 'spouse_health',
    component: HealthComponent,
    data: [{id: 2}]
  }, {
    path: 'children_health/:childId',
    component: ChildrenHealthComponent,
  }, {
    path: 'disease',
    component: DiseaseComponent
  }, {
    path: 'smoke',
    component: SmokingComponent
  }, {
    path: 'live',
    component: LiveComponent
  }, {
    path: 'transit1',
    component: Transit1Component
  }, {
    path: 'transit2',
    component: Transit2Component
  }, {
    path: 'transit3',
    component: Transit3Component
  },
  // {
  //   path: '*',
  //   component: 'TransitComponent'
  // }
];

@NgModule({
  imports: [CommonModule, RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule {
}
