import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {Router} from "@angular/router";
@Component({
  selector: 'app-family',
  templateUrl: './family.component.html',
  styleUrls: ['./family.component.css']
})
export class FamilyComponent implements OnInit {
  curPageData: Array<any>;
  pageAnswers: any;
  selectedOptionId: any;

  constructor(private commonService: CommonService, private router: Router) {
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.commonService.surveyInfo().then(res => {
      this.curPageData = res['data']['survey']['pages'].filter(item => item.pageId === 2).pop();
      // console.log(this.curPageData)
    });
  }

//  选择家庭结构
  selectedFamily(option) {
    this.selectedOptionId = option.optionId;
    option.selected = true;
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: [option]
      }],
    };
    this.commonService.addAnswer(this.pageAnswers);

  }

//   下一步
  next() {
    this.router.navigate(['/age'], {queryParams: {type: this.selectedOptionId}});
  }
}
