import { Component, OnInit } from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-disease',
  templateUrl: './disease.component.html',
  styleUrls: ['./disease.component.css']
})
export class DiseaseComponent implements OnInit {
  curPageData:Array<any>;
  type:any;
  pageAnswers:any;
  nextBtn:boolean;
  options:Array<any>;
  selectedOptionId:any;
  constructor(
    private commonService: CommonService,
    private router: Router, 
    private route: ActivatedRoute
  ) { 
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{optionId: '', optionName: '', optionOrder: '', selected: ''}]
      }],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.surveyInfo()
  }
  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['13']
        /**
         * 1:单身贵族
         * 2：二人世界
         * 3：独立带娃
         * 4：多口之家
         * @type {any}
         */
        //过滤选项
        if(this.type == 1){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 106 || option.optionId == 107
          })
        }
        if(this.type == 2){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 108 || option.optionId == 109 || option.optionId == 111
          })
        }
        if(this.type == 3){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 108 || option.optionId == 110 || option.optionId == 111
          })
        }
        if(this.type == 4){
          this.options = this.curPageData['questions']['0']['options']
          this.options = this.options.filter(option=>{
            return option.optionId == 108 || option.optionId == 109 || option.optionId == 110 || option.optionId == 111
          })
        }
      }
    })
  }

  getAnswer(option){
    // console.log(options)
    this.selectedOptionId = option.optionId;
    this.pageAnswers = {
      pageId : this.curPageData['pageId'],
      questions:[{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options:[option]
      }]
    }
    this.commonService.addAnswer(this.pageAnswers)
    console.log(this.pageAnswers)
    if(this.pageAnswers['questions'].length>0){
      this.nextBtn = true
    }else{
      this.nextBtn = false
    }
  }

  next(){
    if(this.nextBtn == true){
      this.router.navigate(['/smoke'],{queryParams:{type:this.type}})
    }
  }
}
