import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-age',
  templateUrl: './age.component.html',
  styleUrls: ['./age.component.css']
})
export class AgeComponent implements OnInit {
  // 家庭结构
  type: any;
  curPageData: Array<any>;
  isShow: boolean;
  curQues: any;
  curQuesIndex: number;
  curQuestionSelecte: string;
  pageAnswers: any;

  constructor(private commonService: CommonService, private router: Router, private route: ActivatedRoute) {
    /**
     * 1:单身贵族
     * 2：二人世界
     * 3：独立带娃
     * 4：多口之家
     * @type {any}
     */
    this.type = this.route.snapshot.queryParams['type'];
    console.log(this.type);
    this.pageAnswers = {
      pageId: '',
      questions: [],
    };
  }

  ngOnInit() {
    this.commonService.surveyInfo().then(res => {
      this.curPageData = res['data']['survey']['pages'].filter(item => item.pageId === 3).pop();
      this.pageAnswers.pageId = this.curPageData['pageId'];
    });
  }

  // 选择年龄
  selectedAge(curQues, options) {
    const question = {
      questionId: curQues.questionId,
      questionName: curQues.questionName,
      options: [options]
    };
    for (let i = 0; i < this.pageAnswers.questions.length; i++) {
      if (this.pageAnswers.questions[i].questionId == curQues.questionId) {
        const index = this.pageAnswers.questions.indexOf(this.pageAnswers.questions[i]);
        this.pageAnswers.questions.splice(index, 1);
      }
    }
    this.pageAnswers.questions.push(question);
    this.commonService.addAnswer(this.pageAnswers);
    console.log(this.commonService.todos)
    this.closeToast();
  }

  showToast(question, idx) {
    this.isShow = true;
    this.curQues = question;
    this.curQuesIndex = idx;
    this.curQuestionSelecte = question.name;
  }

  closeToast() {
    this.isShow = false;
  }


//   下一步
  next() {
    this.router.navigate(['/job']);
  }
}
