import { Component, OnInit } from '@angular/core';
import { CommonService } from "./common.service";

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent implements OnInit {

  constructor(private commonService: CommonService) {
  }

  ngOnInit() {
    const customerId = this.commonService.getQueryString('customerId');
    const orderId = this.commonService.getQueryString('orderId');
    if (customerId) {
      sessionStorage.setItem('customerId', customerId);
    }
    if (orderId) {
      sessionStorage.setItem('orderId', orderId);
    }
    if (this.commonService.getQueryString('campaign') && this.commonService.getQueryString('task')) {
      const campaignInfo = {
        campaignCode: this.commonService.getQueryString('campaign'),
        campaignTaskCode: this.commonService.getQueryString('task'),
      };
      sessionStorage.setItem('campaignInfo', JSON.stringify(campaignInfo));
    }
  }
}
