import { Component, OnInit } from '@angular/core';
import { CommonService } from '../common.service';
import { ActivatedRoute, Router } from "@angular/router";

@Component({
  selector: 'app-smoking',
  templateUrl: './smoking.component.html',
  styleUrls: ['./smoking.component.css']
})
export class SmokingComponent implements OnInit {
  curPageData: any;
  type: any;
  nextBtn: boolean;
  pageAnswers: any;
  options: Array<any>;
  questions: Array<any> = [];
  lastQuestions: Array<any>;

  constructor(private commonService: CommonService,
    private router: Router,
    private route: ActivatedRoute) {
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [{
        questionId: '',
        questionName: '',
        options: [{ optionId: '', optionName: '', optionOrder: '', selected: '' }]
      }],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.lastQuestions = this.commonService.todosCopy.filter(item => item.pageId == 15).pop();
    this.surveyInfo();
  }

  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['14'];
        this.filterOptions(this.type)
        if (this.lastQuestions) {
          for (let i = 0; i < this.lastQuestions['questions'].length; i++) {
            for (let j = 0; j < this.curPageData['questions'].length; j++) {
              if (this.lastQuestions['questions'][i].questionId == this.curPageData['questions'][j].questionId) {
                this.lastQuestions['questions'][i]['options'].forEach(option => {
                  if (Object.keys(option).indexOf('optionId') > -1) {
                    const targetObj = option;
                    this.curPageData['questions'][j]['options'].forEach(option => {
                      if (targetObj['optionId'] == option['optionId']) {
                        this.curPageData['questions'][j]['options'][this.curPageData['questions'][j]['options'].indexOf(option)] = targetObj;
                        // 过滤选项
                        this.filterOptions(this.type)
                      }
                    });
                    if (this.type == 1) {
                      this.getOneAnswer(targetObj)
                    } else {
                      this.getManyAnswer(targetObj, true)
                    }
                  }
                });
              }
            }
          }
        }
      }
    })
  }

  getOneAnswer(option) {
    for (let i = 0; i < this.options.length; i++) {
      if (option['optionId'] == this.options[i]['optionId']) {
        this.options[i]['selected'] = true;
      } else {
        this.options[i]['selected'] = false;
      }
    }
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: [option]
      }]
    }
    this.commonService.addAnswer(this.pageAnswers);
    if (this.curPageData['questions'].length == this.pageAnswers.questions.length) {
      if (this.pageAnswers.questions.every(item => item.options.length > 0)) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    } else {
      this.nextBtn = false;
    }
  }

  getManyAnswer(option, lastFlag) {
    if (lastFlag === false) {
      option['selected'] = !option['selected'];
    }
    this.questions = [];
    for (let i = 0; i < this.curPageData['questions'][0]['options'].length; i++) {
      if (option.optionId == 117 && option['selected']) {
        this.curPageData['questions'][0]['options'][i]['selected'] = false;
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 117) {
          this.curPageData['questions'][0]['options'][i]['selected'] = true;
        }
      } else {
        if (this.curPageData['questions'][0]['options'][i]['optionId'] == 117) {
          this.curPageData['questions'][0]['options'][i]['selected'] = false;
        }
      }
      // 拿到所有selected为true的选项
      if (this.curPageData['questions'][0]['options'][i]['selected']) {
        this.questions.push(this.curPageData['questions'][0]['options'][i]);
      }
    }
    this.pageAnswers = {
      pageId: this.curPageData['pageId'],
      questions: [{
        questionId: this.curPageData['questions']['0']['questionId'],
        questionName: this.curPageData['questions']['0']['questionName'],
        options: this.questions
      }],
    };
    if (this.curPageData['questions'].length == this.pageAnswers.questions.length) {
      if (this.pageAnswers.questions.every(item => item.options.length > 0)) {
        this.nextBtn = true;
      } else {
        this.nextBtn = false;
      }
    } else {
      this.nextBtn = false;
    }
    this.commonService.addAnswer(this.pageAnswers);
  }

  checkFun(option) {
    if (this.type == 1) {
      this.getOneAnswer(option);
    } else {
      this.getManyAnswer(option, false);
    }
  }

  next() {
    if (this.nextBtn == true) {
      this.router.navigate(['/live'], { queryParams: { type: this.type } })
    } else {
      return;
    }
  }
  filterOptions(type) {
    //过滤选项
    if (type == 1) {
      this.options = this.curPageData['questions']['0']['options'];
      this.options = this.options.filter(option => {
        return option.optionId == 112 || option.optionId == 113;
      })
    }
    if (type == 2) {
      this.options = this.curPageData['questions']['0']['options'];
      this.options = this.options.filter(option => {
        return option.optionId == 114 || option.optionId == 115 || option.optionId == 117;
      })
    }
    if (type == 3) {
      this.options = this.curPageData['questions']['0']['options'];
      this.options = this.options.filter(option => {
        return option.optionId == 114 || option.optionId == 116 || option.optionId == 117;
      })
    }
    if (type == 4) {
      this.options = this.curPageData['questions']['0']['options'];
      this.options = this.options.filter(option => {
        return option.optionId == 114 || option.optionId == 115 || option.optionId == 116 || option.optionId == 117;
      })
    }
  }
  //  上一步
  before() {
    this.commonService.before();
  }
}
