$(function(){
    var api = 'https://m.zuihuibi.cn/api';
    //初始化参数
    var param = {"insurerId":2,"accurateOccupationFlag":1,"industryId":null,"occupationTypeId":null,"occupationName":null}
    var optionListOrigin = "<option value='null' disabled selected hidden>请选择行业</option>"
    var optionListOriginTwo = "<option value='null' disabled selected hidden>请选择职业类别</option>"
    var industryList = '';
    var occupationTypesList = ''
    function getToken(){
        $.ajax({
            type:"POST",
            url:api + '/authorize/obtainToken',
            contentType: "application/json",
            data:JSON.stringify({ticket: 'job'}),
            async:false,
            success:function(res){
                token = res.data.token
            }
        })
        return token;
    }
    var token = getToken()

    //初始化职业类别为请选择
    $("#choseTwo").html(optionListOriginTwo)
    getData();
    function getData(){
        $.ajax({
            type:"POST",
            url:api+'/metadata/occupationQry',
            contentType: "application/json",
            data:JSON.stringify(param),
            headers:{"X-Authorization":token},
            success:function(res){
                if(res.success){
                    var industryData = res.data.industry;
                    for(var i=0;i<industryData.length;i++){
                        industryList += "<option value="+industryData[i].industryId+">"+industryData[i].industryName+"</option>"
                    }
                    $("#chose").html(optionListOrigin+industryList)
                }

            }
        })
    }

    $("#chose").change(function(){
        $("#chose").attr("value",this.value)
        //给行业赋值
        param.industryId= this.value;
        param.occupationTypeId=null;
        param.occupationName=null;
        if($("#chose").val()!= 'null'){
            var num = this.value-1;
            if(this.value !=null){
                $("#choseTwo").removeAttr("disabled");
                $("#choseTwo").removeClass("disabled");
                $.ajax({
                    type:"POST",
                    url:api+'/metadata/occupationQry',
                    contentType: "application/json",
                    data:JSON.stringify(param),
                    headers:{"X-Authorization":token},
                    success:function(res){
                        if(res.success){
                            if(res.data.industry.length>0){
                                var getoccupationTypesData = res.data.industry[0].occupationTypes;
                                occupationTypesList='';
                                for(var i=0;i<getoccupationTypesData.length;i++){
                                    occupationTypesList += "<option value="+getoccupationTypesData[i].occupationTypeId+">"+getoccupationTypesData[i].occupationTypeName+"</option>"
                                }
                                $("#choseTwo").html(optionListOriginTwo+occupationTypesList)
                            }else{
                                $("#choseTwo").html(optionListOriginTwo)
                            }

                        }
                    }
                })
            }
        }else{
            param.occupationTypeId=null;
            $("#choseTwo").html(optionListOriginTwo)
            $("#choseTwo").attr("disabled","disabled");
        }
    })

    //给职业类别赋值
    $("#choseTwo").change(function(){
        $("#choseTwo").attr("value",this.value)
        param.occupationTypeId= this.value;
    })

    $(".searchBtn").click(function(){
        var contentList = ''
        if($(".search input").val()){
            param.occupationName =  $(".search input").val()
        }else{
            param.occupationName=null;
        }
        $.ajax({
            type:"POST",
            url:api+'/metadata/occupationQry',
            contentType: "application/json",
            data:JSON.stringify(param),
            headers:{"X-Authorization":token},
            success:function(res){
                if(res.success){
                    $("#table").show();
                    $(".noResult").hide();
                    if($("#chose").val()!=null){
                        if(res.data.industry.length>0){
                            var industryName = res.data.industry[0].industryName;
                            var occupationTypesData = res.data.industry[0].occupationTypes;
                            for(var i=0;i<occupationTypesData.length;i++){
                                for(var j=0;j<occupationTypesData[i].occupations.length;j++){
                                    contentList +="<tr><td>"
                                        +industryName+"</td><td>"
                                        +occupationTypesData[i].occupationTypeName+"</td><td>"
                                        +occupationTypesData[i].occupations[j].occupationName+"</td><td>"
                                        +occupationTypesData[i].occupations[j].occupationCode+"</td><td>"
                                        +occupationTypesData[i].occupations[j].occupationClass+"</td></tr>"
                                }
                            }
                        }else{
                            $("#table").hide();
                            $(".noResult").show();
                        }
                    }else{
                        var allData = res.data.industry
                        for(var i=0;i<allData.length;i++){
                            for(var j=0;j<allData[i].occupationTypes.length;j++){
                                for(var k=0;k<allData[i].occupationTypes[j].occupations.length;k++){
                                    contentList +="<tr><td>"
                                        +allData[i].industryName+"</td><td>"
                                        +allData[i].occupationTypes[j].occupationTypeName+"</td><td>"
                                        +allData[i].occupationTypes[j].occupations[k].occupationName+"</td><td>"
                                        +allData[i].occupationTypes[j].occupations[k].occupationCode+"</td><td>"
                                        +allData[i].occupationTypes[j].occupations[k].occupationClass+"</td></tr>"
                                }
                            }
                        }
                    }

                    $("#table tbody").html(contentList)
                    $('.total span').html(res.data.industryNum)
                }else{
                    $("#table").hide();
                    $(".noResult").show();
                }
            }
        })
    })

    $(".reset").click(function(){
        param.industryId=null;
        param.occupationTypeId=null;
        param.occupationName=null;
        $(".search input").val('')
        $("#chose").html(optionListOrigin)
        $("#choseTwo").html(optionListOriginTwo)
        $("#choseTwo").attr("disabled","disabled");
        $("#choseTwo").addClass("disabled");
        getData();
    })

    if( /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent) ) {
        loadStyle('./css/mstyle.css')
    } else {
        loadStyle('./css/style.css');
    }

    function loadStyle(url){
        var link = document.createElement('link');
        link.type = 'text/css';
        link.rel = 'stylesheet';
        link.href = url;
        var head = document.getElementsByTagName('head')[0];
        head.appendChild(link);
    }


})