import {BrowserModule} from '@angular/platform-browser';
import {NgModule} from '@angular/core';
import {HashLocationStrategy, LocationStrategy} from '@angular/common';

import {AppRoutingModule} from './app-routing.module';
import {AppComponent} from './app.component';
import {FamilyComponent} from './family/family.component';
import {AgeComponent} from './age/age.component';
import {JobComponent} from './job/job.component';
import {IncomeComponent} from './income/income.component';
import {LoanComponent} from './loan/loan.component';
import {SocialSecurityComponent} from './social-security/social-security.component';
import {HealthComponent} from './health/health.component';
import {ChildrenHealthComponent} from './children-health/children-health.component';
import {DiseaseComponent} from './disease/disease.component';
import {SmokingComponent} from './smoking/smoking.component';
import {LiveComponent} from './live/live.component';
import {TransitComponent} from './transit/transit.component';
import {Transit1Component} from './transit1/transit1.component';
import {Transit2Component} from './transit2/transit2.component';
import {Transit3Component} from './transit3/transit3.component';

import {HttpClientModule} from '@angular/common/http'
import {CommonService} from './common.service'
import {LocalStorage} from './local.storage';
import { SpecialMmhComponent } from './special-mmh/special-mmh.component'
@NgModule({
  declarations: [
    AppComponent,
    FamilyComponent,
    AgeComponent,
    JobComponent,
    IncomeComponent,
    LoanComponent,
    SocialSecurityComponent,
    HealthComponent,
    ChildrenHealthComponent,
    DiseaseComponent,
    SmokingComponent,
    LiveComponent,
    TransitComponent,
    Transit1Component,
    Transit2Component,
    Transit3Component,
    SpecialMmhComponent
  ],
  imports: [
    BrowserModule,
    AppRoutingModule
    , HttpClientModule
  ],
  providers: [CommonService, LocalStorage, {provide: LocationStrategy, useClass: HashLocationStrategy}],
  bootstrap: [AppComponent]
})
export class AppModule {
}
