import {Component, OnInit} from '@angular/core';
import {Router, ActivatedRoute} from '@angular/router';
import {CommonService} from "../common.service";
@Component({
  selector: 'app-transit1',
  templateUrl: './transit1.component.html',
  styleUrls: ['./transit1.component.css']
})
export class Transit1Component implements OnInit {
  type: any;

  constructor(private router: Router,
              private commonService: CommonService,
              private route: ActivatedRoute) {
    /**
     * 1:单身贵族
     * 2：二人世界
     * 3：独立带娃
     * 4：多口之家
     * @type {any}
     */
    this.type = this.route.snapshot.queryParams['type'];
  }

  ngOnInit() {
  }

  next() {
    this.router.navigate(['/income'], {queryParams: {type: this.type}})
  }

  //  上一步
  before() {
    this.commonService.before();
  }
}
