$(function () {
    // var api = 'https://' + window.location.host;
    var api = 'https://mstage.zuihuibi.cn';
    var gitUrlParam = window.location.search;
    const param = {
        phone: '',
        deviceType: '',
        verificationCodeValider: false,
        customerId: '',
        name: '',
    }
    const REG_CODE = /^(1)\d{10}$/;
    const REG_NAME = /(^[\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\.·。]{0,48}[\u4e00-\u9fa5]{1}$)|(^[a-zA-Z]{1}[a-zA-Z\s]{0,48}[a-zA-Z]{1}$)/;
    $("#phone,#name,#code").blur(function () {
        window.scrollTo(0, 0);
    })
    var deviceType = checkDeviceType();
    param.deviceType = deviceType;
    function getToken() {
        $.ajax({
            type: "POST",
            url: api + '/api/authorize/obtainToken',
            contentType: "application/json",
            data: JSON.stringify({ticket: 'job'}),
            async: false,
            success: function (res) {
                token = res.data.token
            }
        })
        return token;
    }

    var token = getToken();
    $(".order").click(function () {
        $("#phone").val('')
        $("#code").val('')
        $("#name").val('')
        $('.modalBox').show();
    })
    $('.closeModal').click(function () {
        $('.modalBox').hide();
    })
    if (getQueryString('hmsr') || getQueryString('hmpl') || getQueryString('hmkw') || getQueryString('hmci')) {
        window.localStorage.setItem('hmsr', getQueryString('hmsr'))
        window.localStorage.setItem('hmpl', getQueryString('hmpl'))
        window.localStorage.setItem('hmkw', getQueryString('hmkw'))
        window.localStorage.setItem('hmci', getQueryString('hmci'))
    }
    function getQueryString(name) {
        const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
        const r = decodeURIComponent(gitUrlParam).substr(1).match(reg);
        if (r != null) {
            return r[2];
        }
        return null;
    }

    function checkDeviceType() {
        if (/Android|webOS|iPhone|iPod|BlackBerry/i.test(navigator.userAgent)) {
            if (navigator.userAgent.toLowerCase().indexOf('micromessenger') !== -1) {
                deviceType = '3';
            } else {
                deviceType = '2';
            }
        } else {
            deviceType = '1';
        }
        return deviceType;
    }

    var deviceType = checkDeviceType();
    param.deviceType = deviceType;
    sendPhone()
    //发送验证码
    function sendPhone() {
        $("#codeBtn").click(function () {
            if (!$("#phone").val()) {
                layer.open({
                    content: '手机号不能为空！'
                    , skin: 'msg'
                    , time: 3
                });
                return;
            }
            if (!REG_CODE.test($("#phone").val())) {
                layer.open({
                    content: '请输入正确的手机号码！'
                    , skin: 'msg'
                    , time: 3 //2秒后自动关闭
                });
                return;
            }
            $.ajax({
                type: "POST",
                url: api + '/api/verificationCode',
                contentType: "application/json",
                data: JSON.stringify({type: 1, mobileNo: $("#phone").val()}),
                headers: {"X-Authorization": token},
                async: false,
                success: function (res) {
                    if (res.success) {
                        layer.open({
                            content: '发送成功',
                            skin: 'msg',
                            time: 3 //2秒后自动关闭
                        });
                        $('#codeBtn').attr('disabled', true)
                        var timeCount = 60;
                        var codeBtnHtml = '获取验证码';
                        var timer = setInterval(function () {
                            timeCount--;
                            codeBtnHtml = '(' + timeCount + ')s';
                            if (timeCount <= 0) {
                                codeBtnHtml = '重新获取';
                                clearInterval(timer);
                                timeCount = 60;
                                $('#codeBtn').removeAttr('disabled')
                            }
                            $("#codeBtn").html(codeBtnHtml)
                        }, 1000)
                    } else {
                        layer.open({
                            content: res.message,
                            skin: 'msg',
                            time: 3
                        })
                    }
                }
            })
        })
    }

    checkVerificationCode()
    //验证验证码
    function checkVerificationCode() {
        $("#code").keyup(function () {
            if ($("#code").val().length == 4) {
                const verificationCodeRequest = {
                    mobileNo: $("#phone").val(),
                    verificationCode: $("#code").val(),
                }
                if ($("#phone").val() && $("#code").val()) {
                    if (!REG_CODE.test($("#phone").val())) {
                        layer.open({
                            content: '请输入正确的手机号码！'
                            , skin: 'msg'
                            , time: 3 //2秒后自动关闭
                        });
                        return;
                    }
                    $.ajax({
                        url: api + '/api/checkVerificationCode',
                        type: 'POST',
                        contentType: "application/json",
                        data: JSON.stringify(verificationCodeRequest),
                        headers: {"X-Authorization": token},
                        success: function (res) {
                            param.verificationCodeValider = res.success;
                            if (!res.success) {
                                layer.open({
                                    content: res.message,
                                    skin: 'msg',
                                    time: 3
                                })
                            }
                            $.ajax({
                                url: api + '/api/login',
                                method: 'POST',
                                contentType: "application/json",
                                headers: {"X-Authorization": token},
                                data: JSON.stringify({mobileNo: $("#phone").val()}),
                                success: function (res) {
                                    param.customerId = res.data.customerId;
                                    var customerInfo = {
                                        customerId: res.data.customerId,
                                        customerName: res.data.customerName,
                                        customerNickName: res.data.customerNickName,
                                        headImgPath: res.data.headImgePath,
                                        cusLevel: res.data.cusLevel,
                                        cusLevelDesc: res.data.cusLevelDesc,
                                        referralLevel: res.data.referralLevel,
                                        referralLevelDesc: res.data.referralLevelDesc,
                                        totalFortune: res.data.totalFortune,
                                        mobileNo: $("#phone").val()
                                    };
                                    localStorage.setItem('customerInfo', JSON.stringify(customerInfo));
                                    if (!res.success) {
                                        layer.open({
                                            content: res.message,
                                            skin: 'msg',
                                            time: 3
                                        })
                                    }
                                }
                            })
                        }
                    })
                } else {
                    param.verificationCodeValider = false;
                }
            }

        })
    }

    getPay();
    function getPay() {
        $("#pay").click(function () {
            if (!REG_CODE.test($("#phone").val())) {
                layer.open({
                    content: '请输入正确的手机号码！'
                    , skin: 'msg'
                    , time: 3 //2秒后自动关闭
                });
                return;
            } else {
                param.phone = $("#phone").val()
            }
            if (!param.verificationCodeValider) {
                layer.open({
                    content: '请检查您的验证码是否正确'
                    , skin: 'msg'
                    , time: 3 //2秒后自动关闭
                });
                return;
            }
            if (!REG_NAME.test($("#name").val())) {
                layer.open({
                    content: '请检查您的姓名是否正确！'
                    , skin: 'msg'
                    , time: 3 //2秒后自动关闭
                });
                return;
            } else {
                param.name = $("#name").val()
            }
            const startDate = new Date();
            const endDate = new Date(new Date(startDate).setFullYear(new Date(startDate).getFullYear() + 1));
            endDate.setDate(endDate.getDate() - 1);
            const data = {
                customerId: param.customerId,
                planId: '424',
                startDate: startDate.getFullYear() + '-' + dateFormat((Number(startDate.getMonth()) + 1)) + '-' + dateFormat((Number(startDate.getDate()))),
                endDate: endDate.getFullYear() + '-' + dateFormat((Number(endDate.getMonth()) + 1)) + '-' + dateFormat((Number(endDate.getDate()))),
                price: '49',
                holder: {
                    name: param.name,
                    mobileNo: param.phone
                },
                channelLaunchAD: {
                    hmsr: window.localStorage.getItem('hmsr'),
                    hmpl: window.localStorage.getItem('hmpl'),
                    hmkw: window.localStorage.getItem('hmkw'),
                    hmci: window.localStorage.getItem('hmci')
                },
                deviceType: param.deviceType,
                paymentMethod: '1',
            }
            if (isWeiXin()) {
                data.paymentMethod = '1';
            } else {
                data.paymentMethod = '2';
            }
            $.ajax({
                url: api + '/api/voucherBuy',
                type: 'POST',
                contentType: "application/json",
                data: JSON.stringify(data),
                headers: {"X-Authorization": token},
                success: function (res) {
                    if (res['commonResult']) {
                        if (res['content']) {
                            const action = res['content']['action'];
                            const params = res['content']['param'];
                            const actionType = res['content']['actionType'];
                            const charset = res['content']['charset'];
                            getOrPost(action, params, charset, actionType);
                        }
                    } else {
                        layer.open({
                            content: res.message,
                            skin: 'msg',
                            time: 3
                        })
                    }
                }
            })
        })
    }

    function dateFormat(e) {
        if (Number(e) < 10) {
            return '0' + e;
        } else {
            return e;
        }
    }

    // 判断是get请求还是post请求进行支付请求
    function getOrPost(action, params, charset, actionType) {
        let url = '';
        let paramHTML = '';
        let hiddenContent = '';
        const d = document.getElementById('d');
        if (actionType.toLowerCase() === 'get') {
            url = action;
            if (params) {
                for (let i = 0; i < params.length; i++) {
                    url += '&' + params[i].name + '=' + params[i].value;
                }
            }
            window.location.href = url;
        } else if (actionType.toLowerCase() === 'post') {
            if (params) {
                for (let i = 0; i < params.length; i++) {
                    paramHTML += '<input type="text" value="' + params[i].value + '" name="' + params[i].name + '" hidden>'
                }
            }
            hiddenContent +=
                '<form action="' + action + '"method="post" accept-charset="' + charset + '" onsubmit="document.charset=\'' + charset + '\';">'
                + paramHTML
                + '<button type="submit" id="submit" hidden></button>'
                + '</form>';
            d.innerHTML = hiddenContent;
            document.getElementById('submit').click()
        }
    }

    function isWeiXin() {
        var ua = window.navigator.userAgent.toLowerCase();
        if (ua.match(/MicroMessenger/i) == 'micromessenger' || ua.match(/_SQ_/i) == '_sq_') {
            return true;
        } else {
            return false;
        }
    }
    getWxConfig();
//    获取微信分享配置
    function getWxConfig()
    {
        var url = location.href.split('#')[0];
        $.ajax({
            type: "POST",
            url: api + '/api/wxConfig',
            contentType: "application/json",
            data: JSON.stringify({url: url}),
            headers: {"X-Authorization": token},
            async: false,
            success: function (res) {
                wx.config({
                    debug: false,
                    appId: res.data.appId,
                    timestamp: res.data.timestamp,
                    nonceStr: res.data.nonceStr,
                    signature: res.data.signature,
                    jsApiList: res.data.jsApiList,
                    beta: true
                });
                // 默认的分享信息
                const shareData = {
                    title: '1对1家庭风险管理服务',
                    link: window.location.href,
                    desc: '产品太多、条款复杂、买哪个好，理不理赔? 獴哥保险诊所来帮您解决，提供1对1风险分析和保险方案定制。',
                    imgUrl: 'https://ajb-images.oss-cn-shanghai-finance-1-pub.aliyuncs.com/images/menggo_head.png'
                };
                wx.ready(function () {
                    wx.onMenuShareAppMessage(shareData);  // 分享微信
                    wx.onMenuShareTimeline(shareData);    // 分享到朋友圈
                    wx.onMenuShareQQ(shareData);          // 分享到QQ
                });
            }
        })
    }
});