import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core'

@Component({
  selector: 'app-page2',
  templateUrl: './page2.component.html',
  styleUrls: ['./page2.component.css']
})
export class Page2Component implements OnInit {
  @Input() curPageData: Array<any>
  @Output() getAllAnswer = new EventEmitter<any>()

  selectedObj:Object;
  constructor() {}

  ngOnInit() {
    this.selectedObj = {}
    this.setOptionSelected()
  }
  getAnswer(option) {
    if(!this.selectedObj['selected']){
      this.selectedObj = option
      option['selected'] = true;
    }else{
      if(this.selectedObj['optionId']!=option.optionId){
        this.selectedObj['selected'] = false;
        option['selected'] = true;
        this.selectedObj = option
      }
    }
    const ret = {
      pageId: this.curPageData['pageId'],
      questions: [
        {
          questionId: this.curPageData['questions'][0].questionId,
          questionName: this.curPageData['questions'][0].questionName,
          options: [option]
        }
      ]
    }
    // console.log(this.curPageData['questions']);
    // console.log(ret.questions)
    this.getAllAnswer.emit(ret);
    console.log(ret)
    // console.log(ret)
  }

  setOptionSelected() {
    const options = this.curPageData['questions'][0].options
    if (!options) {
      return
    }
     options.forEach(option => {
        if (option['selected']) {
          this.selectedObj = option;
          this.getAnswer(this.selectedObj)
        }
      })
  }
}
