import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-income',
  templateUrl: './income.component.html',
  styleUrls: ['./income.component.css']
})
export class IncomeComponent implements OnInit {
  hasMate: boolean;
  curPageData: Array<any>;
  pageAnswers: any;
  // 家庭结构
  type: any;
  selectedOptionId: any;
  nextBtn:boolean;

  constructor(private commonService: CommonService,
              private router: Router,
              private route: ActivatedRoute) {
    /**
     * 1:单身贵族
     * 2：二人世界
     * 3：独立带娃
     * 4：多口之家
     * @type {any}
     */
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [],
    };
  }

  ngOnInit() {
    this.surveyInfo()
    //判断家庭决定是否显示配偶
    if(this.type==2 || this.type == 4){
      this.hasMate = true;
    }else{
      this.hasMate = false;
    }
    this.nextBtn = false;
  }

  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['6']
        console.log(this.curPageData)
        this.pageAnswers.pageId = this.curPageData['pageId'];
      }
    })
  }

  selectedIncome(question, option) {
    this.selectedOptionId = option.optionId;
    option.selected = true;
    const questions = {
      questionId: question.questionId,
      questionName: question.questionName,
      options: [option]
    };
    for (let i = 0; i < this.pageAnswers.questions.length; i++) {
      if (this.pageAnswers.questions[i].questionId == question.questionId) {
        const index = this.pageAnswers.questions.indexOf(this.pageAnswers.questions[i]);
        this.pageAnswers.questions.splice(index, 1);
      }
    }
    this.pageAnswers.questions.push(questions);
    this.commonService.addAnswer(this.pageAnswers);
    console.log(questions)
    console.log(this.pageAnswers)
    //判断页面需要几个问题
    if(this.type==2 || this.type == 4){
      if(this.curPageData['questions'].length == this.pageAnswers['questions'].length){
        this.nextBtn = true;
      }else{
        this.nextBtn = false;
      }
    }else{
      if(this.pageAnswers['questions'].length>0){
        this.nextBtn = true;
      }else{
        this.nextBtn = false;
      }
    }
  }

  next(){
    if(this.nextBtn == true){
      this.router.navigate(['/loan'],{queryParams:{type:this.type}})
    }else{
      return;
    }
  }
}
