import {Component} from '@angular/core';
import {EventBusService} from "./event-bus.service";
declare const wx: any;
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
  constructor(private eventBusService: EventBusService) {
    setTimeout(() => {
      this.wxConfig();
    }, 500)
  }

  wxConfig() {
    const url = location.href.split('#')[0];
    this.eventBusService.getWXJsInitConfig(url).then(res => {
      const data = res['data'];
      wx.config({
        debug: false,
        appId: data.appId,
        timestamp: data.timestamp,
        nonceStr: data.nonceStr,
        signature: data.signature,
        jsApiList: data.jsApiList,
        beta: true
      });
      this.eventBusService.noShareCode();
    });
  }
}
