import { Injectable } from '@angular/core';
import {Subject} from 'rxjs'; 
@Injectable({
  providedIn: 'root'
})
export class DataService {
  private dataSource = new Subject<any>();
  answerList$ = this.dataSource.asObservable();
  answerList: Array<any> = []; // 选择结果列表
  pageId:number;
  constructor() { }
  
  // 添加answer
  addAnswer(todo) {
    if (this.answerList.length > 0) {
      this.pageId = this.answerList[this.answerList.length - 1].id;
    } else {
      this.pageId = 0;
    }
    if (!todo.id) {
      todo.id = ++this.pageId;
    }
    this.answerList.push(todo);
    this.dataSource.next(this.answerList);
    return this;
  }

  getAnswer() {
    return this.answerList;
  }
}
