$(function () {
    //var api = 'https://mdev.zuihuibi.cn';
	var api = window.location.origin;
    function getToken() {
        $.ajax({
            type: "POST",
            url: api + '/api/authorize/obtainToken',
            contentType: "application/json",
            data: JSON.stringify({
                ticket: 'job'
            }),
            async: false,
            success: function (res) {
                token = res.data.token
            }
        })
        return token;
    }

    var token = getToken();
    getXBDetailInfo();
    function getXBDetailInfo() {
        $.ajax({
            url: api + '/api/activity/getXBDetailInfo',
            type: 'POST',
            contentType: "application/json",
            data: JSON.stringify({
                orderId: getQueryString('orderId')
            }),
            headers: {
                "X-Authorization": token
            },
            success: function (res) {
                if (res['success']) {
                    $('.relativeContent').css({'background':'url(' + res['data']['xbUrl'] + ') no-repeat center center','background-size':'cover'});
                    $('.content #productName').html(res['data']['orderInfo']['productName']);
                    $('.content #insurerName').html(res['data']['orderInfo']['insurerName']);
                    if (res['data']['orderInfo']['paymentPeriod'] && parseInt(res['data']['orderInfo']['paymentPeriod'], 0) > 0) {
                        $('.content #paymentPeriod').html(`${res['data']['orderInfo']['paymentPeriod']}期`);
                    }

                    $('.content #fyp').html(`FYP ${numFormat(res['data']['orderInfo']['premium'])}`);
                    $('.content #belongToCompany').html(res['data']['practitionerInfo']['insurerBranchName']);
                    $('.content #subordinateName').html(res['data']['practitionerInfo']['subordinateName']);
                    $('.content #name').html(res['data']['practitionerInfo']['name']);
                }
            }
        })
    }

//    金额千分号
    function numFormat(num) {
        var c = (num.toString().indexOf('.') !== -1) ? num.toLocaleString() : num.toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,');
        return c;
    }

//    获取URL的参数
    /**
     * url中的参数
     * @param name
     * @returns {any}
     */
    function getQueryString(name) {
        const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
        const r = decodeURIComponent(window.location.search).substr(1).match(reg);
        if (r != null) {
            return r[2];
        }
        return null;
    }
});