import { Component, OnInit, OnDestroy} from '@angular/core';
import {CommonService} from '../common.service';
import {Subscription}   from 'rxjs';
import {DataService} from '../data.service';
@Component({
  selector: 'app-askdetail',
  templateUrl: './askdetail.component.html',
  styleUrls: ['./askdetail.component.css']
})
export class AskdetailComponent implements OnInit , OnDestroy{
  questionList:Array<any>;
  answerList:Array<any>;
  subscription: Subscription;
  constructor(
    private commonService:CommonService,
    private dataService:DataService
  ) {
    this.answerList = this.dataService.answerList;
    this.subscription = dataService.answerList$.subscribe(
      answerList => {
        this.answerList = answerList;
      });
   }

   ngOnInit() {
    this.surveyInfo();
  }
  ngOnDestroy() {
    this.subscription.unsubscribe();
  }

  surveyInfo(){
    this.commonService.surveyInfo().then(res=>{
      if(res['success']){
        this.questionList = res['data']['survey'].pages[1]
        console.log(this.questionList)
      }
    })
  }
}
