import { Component, OnInit } from '@angular/core';
import {CommonService} from '../common.service'
@Component({
  selector: 'app-page-two',
  templateUrl: './page-two.component.html',
  styleUrls: ['./page-two.component.css']
})
export class PageTwoComponent implements OnInit {
  isShow:boolean;
  constructor(private commonService:CommonService) { }
  questionList:Array<any>;
  pageName:string;
  optionsList:Array<any>;
  ngOnInit() {
    this.surveyInfo();
  }

  surveyInfo(){
    this.commonService.surveyInfo().then(res=>{
      if(res['success']){
        this.questionList = res['data']['survey'].pages[2];console.log(this.questionList)
        this.pageName = res['data']['survey'].pages[2].pageName;
        this.optionsList = res['data']['survey'].pages[2].questions
      }
    })
  }
  showToast(){
    this.isShow = true;
  }
  closeToast(){
    this.isShow = false;
  }
}
