import { Component, OnInit } from '@angular/core';
import {CommonService} from '../common.service';

@Component({
  selector: 'app-ask',
  templateUrl: './ask.component.html',
  styleUrls: ['./ask.component.css']
})
export class AskComponent implements OnInit {
  allQues:Array<any>;
  curPage: number;
  totalPage: number;
  curQues: string;
  curPageData: Object;
  allAnswers: Array<any>;
  constructor(
    private commonService:CommonService
    ) {

   }

  ngOnInit() {
    this.surveyInfo()
    this.curPage = 0
    this.totalPage = 17
    this.curPageData = []
    setTimeout(()=>{
      this.curPageData = this.allQues[this.curPage]
    },500)
    
  }

  surveyInfo(){
    this.commonService.surveyInfo().then(res=>{
      if(res['success']){
        this.allQues = res['data']['survey'].pages
        
      }
    })
  }
  reducePage() {
    if(this.curPage>0){
      this.curPage--
      this.curPageData = this.allQues[this.curPage]
    }else{
      return
    }
  }

  addPage() {
    if(this.curPage<16){
      this.curPage++
      this.curPageData = this.allQues[this.curPage]
    }else{
      this.curPage = 0
      return;
    }
    console.log(this.curPage)
  }
}
